/*
 * Decompiled with CFR 0.152.
 */
package authzadmin;

import authzadmin.OauthSettings;
import authzadmin.Scope;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OauthClientDetails
extends BaseClientDetails {
    public static final String AUTO_APPROVE_SCOPE = "true";
    private static final String DEFAULT_AUTHORIZED_GRANT_TYPES = "authorization_code,refresh_token,implicit";

    public OauthClientDetails(OauthSettings oauthSettings) {
        super(oauthSettings.getConsumerKey(), null, CollectionUtils.isEmpty(oauthSettings.getScopes()) ? null : StringUtils.collectionToCommaDelimitedString((Collection)oauthSettings.getScopes().stream().map(Scope::getValue).collect(Collectors.toList())), oauthSettings.isClientCredentialsAllowed() ? "authorization_code,refresh_token,implicit," + "client_credentials" : DEFAULT_AUTHORIZED_GRANT_TYPES, null, oauthSettings.getCallbackUrl());
        this.setClientSecret(oauthSettings.getSecret());
        if (oauthSettings.isAutoApprove()) {
            this.setAutoApproveScopes(Collections.singletonList(AUTO_APPROVE_SCOPE));
        }
        if (oauthSettings.isResourceServer()) {
            this.setAuthorities(AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_TOKEN_CHECKER"}));
            this.setAuthorizedGrantTypes(Collections.emptyList());
        }
    }
}

