/*
 * Decompiled with CFR 0.152.
 */
package authzadmin;

import authzadmin.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.URL;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.CollectionUtils;

public class OauthSettings {
    @NotNull
    @Size(min=1)
    private String secret = UUID.randomUUID().toString();
    @NotNull
    @Size(min=1)
    private String consumerKey;
    @URL
    private String callbackUrl;
    private boolean autoApprove;
    private boolean resourceServer;
    private boolean clientCredentialsAllowed;
    @Valid
    private List<Scope> scopes = new ArrayList<Scope>();

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove;
    }

    public boolean isAutoApprove() {
        return this.autoApprove;
    }

    public boolean isResourceServer() {
        return this.resourceServer;
    }

    public void setResourceServer(boolean resourceServer) {
        this.resourceServer = resourceServer;
    }

    public boolean isClientCredentialsAllowed() {
        return this.clientCredentialsAllowed;
    }

    public void setClientCredentialsAllowed(boolean clientCredentialsAllowed) {
        this.clientCredentialsAllowed = clientCredentialsAllowed;
    }

    public OauthSettings() {
    }

    public OauthSettings(String secret, String consumerKey, String callbackUrl) {
        this.secret = secret;
        this.consumerKey = consumerKey;
        this.callbackUrl = callbackUrl;
    }

    public OauthSettings(ClientDetails clientDetails) {
        this.secret = clientDetails.getClientSecret();
        this.consumerKey = clientDetails.getClientId();
        Set redirectUris = clientDetails.getRegisteredRedirectUri();
        this.callbackUrl = CollectionUtils.isEmpty((Collection)redirectUris) ? null : (String)redirectUris.iterator().next();
        Set scopes = clientDetails.getScope();
        this.scopes = CollectionUtils.isEmpty((Collection)scopes) ? null : scopes.stream().map(Scope::new).collect(Collectors.toList());
        this.autoApprove = clientDetails.isAutoApprove("auto");
        Collection authorities = clientDetails.getAuthorities();
        this.resourceServer = CollectionUtils.isEmpty((Collection)authorities) ? false : authorities.stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals("ROLE_TOKEN_CHECKER"));
        this.clientCredentialsAllowed = clientDetails.getAuthorizedGrantTypes().stream().anyMatch(grant -> grant.equals("client_credentials"));
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OauthSettings that = (OauthSettings)o;
        if (this.callbackUrl != null ? !this.callbackUrl.equals(that.callbackUrl) : that.callbackUrl != null) {
            return false;
        }
        if (this.consumerKey != null ? !this.consumerKey.equals(that.consumerKey) : that.consumerKey != null) {
            return false;
        }
        return !(this.secret != null ? !this.secret.equals(that.secret) : that.secret != null);
    }

    public boolean isNewClient() {
        return this.consumerKey == null;
    }

    public int hashCode() {
        int result = this.secret != null ? this.secret.hashCode() : 0;
        result = 31 * result + (this.consumerKey != null ? this.consumerKey.hashCode() : 0);
        result = 31 * result + (this.callbackUrl != null ? this.callbackUrl.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OauthSettings{consumerKey='" + this.consumerKey + '\'' + ", callbackUrl='" + this.callbackUrl + '\'' + '}';
    }
}

