/*
 * Decompiled with CFR 0.152.
 */
package authzadmin.web;

import authzadmin.OauthClientDetails;
import authzadmin.OauthSettings;
import authzadmin.web.BaseController;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.client.JdbcClientDetailsService;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class ClientController
extends BaseController {
    @Autowired
    private ClientRegistrationService clientRegistrationService;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public ModelAndView get(OauthSettings oauthSettings) {
        return new ModelAndView("create");
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String post(@Valid OauthSettings oauthSettings, BindingResult bindingResult, RedirectAttributes redirectAttributes) {
        if (bindingResult.hasErrors()) {
            return "create";
        }
        try {
            this.transactionTemplate.execute(transactionStatus -> {
                this.clientRegistrationService.addClientDetails((ClientDetails)new OauthClientDetails(oauthSettings));
                return null;
            });
            this.notice(redirectAttributes, "create.success", new Object[0]);
            return "redirect:/";
        }
        catch (ClientAlreadyExistsException e) {
            bindingResult.rejectValue("consumerKey", "create.clientAlreadyExists");
            return "create";
        }
    }

    @RequestMapping(value={"/clients/{id}/edit"}, method={RequestMethod.POST})
    public ModelAndView edit(@PathVariable(value="id") String id, OauthSettings oauthSettings) throws UnsupportedEncodingException {
        String decodedId = URLDecoder.decode(id, "UTF-8");
        ClientDetails clientDetails = ((JdbcClientDetailsService)this.clientRegistrationService).loadClientByClientId(decodedId);
        return new ModelAndView("create", "oauthSettings", (Object)new OauthSettings(clientDetails));
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public String update(@Valid OauthSettings oauthSettings, BindingResult bindingResult, RedirectAttributes redirectAttributes) {
        if (bindingResult.hasErrors()) {
            return "create";
        }
        this.transactionTemplate.execute(transactionStatus -> {
            this.clientRegistrationService.updateClientDetails((ClientDetails)new OauthClientDetails(oauthSettings));
            return null;
        });
        this.notice(redirectAttributes, "edit.success", new Object[0]);
        return "redirect:/";
    }

    @RequestMapping(value={"/clients/{id}/reset"}, method={RequestMethod.POST})
    public String post(@PathVariable String id, RedirectAttributes redirectAttributes) throws UnsupportedEncodingException {
        String decoded = URLDecoder.decode(id, "UTF-8");
        String newSecret = UUID.randomUUID().toString();
        this.transactionTemplate.execute(transactionStatus -> {
            this.clientRegistrationService.updateClientSecret(decoded, newSecret);
            return null;
        });
        this.notice(redirectAttributes, "reset.success", newSecret);
        return "redirect:/";
    }
}

