/*
 * Decompiled with CFR 0.152.
 */
package authzadmin.web;

import authzadmin.ClientDetailsWrapper;
import authzadmin.web.BaseController;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/"})
public class IndexController
extends BaseController
implements ApplicationListener<ContextRefreshedEvent> {
    @Value(value="${defaultClientsAndResourceServers.config.path}")
    private String configFileLocation;
    @Autowired
    private ResourceLoader resourceLoader;
    @Value(value="${allowed_group}")
    private String allowedGroup;
    private List<String> immutableClientIds = new ArrayList<String>();
    @Autowired
    private ClientRegistrationService clientRegistrationService;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public ModelAndView index() {
        List clients = (List)this.transactionTemplate.execute(transactionStatus -> this.clientRegistrationService.listClientDetails());
        clients.sort((l, r) -> l.getClientId().compareTo(r.getClientId()));
        List wrappedClients = clients.stream().map(client -> new ClientDetailsWrapper((ClientDetails)client, this.isMutable(client.getClientId()))).collect(Collectors.toList());
        return new ModelAndView("index", "clients", wrappedClients);
    }

    @RequestMapping(value={"/forbidden"})
    public ModelAndView forbidden() {
        return new ModelAndView("forbidden", (Map)ImmutableMap.of((Object)"allowedGroup", (Object)this.allowedGroup));
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        try {
            Resource resource = this.resourceLoader.getResource(this.configFileLocation);
            Config config = ConfigFactory.parseReader((Reader)new InputStreamReader(resource.getInputStream()));
            this.immutableClientIds.addAll(this.mapClientIds(config.getObjectList("clients")));
            this.immutableClientIds.addAll(this.mapClientIds(config.getObjectList("resourceServers")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read configuration", e);
        }
    }

    private List<String> mapClientIds(List<? extends ConfigObject> clients) {
        return clients.stream().map(clientConfigObj -> {
            Map clientConfig = clientConfigObj.unwrapped();
            return (String)clientConfig.get("clientId");
        }).collect(Collectors.toList());
    }

    private boolean isMutable(String clientId) {
        return !this.immutableClientIds.contains(clientId);
    }
}

