/*
 * Decompiled with CFR 0.152.
 */
package authzadmin;

import authzadmin.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.URL;

public class OauthSettings {
    @NotNull
    @Size(min=1)
    private String secret = UUID.randomUUID().toString();
    @NotNull
    @Size(min=1)
    private String consumerKey;
    @NotNull
    @Size(min=1)
    @URL
    private String callbackUrl;
    @Valid
    private List<Scope> scopes = new ArrayList<Scope>();

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public OauthSettings() {
    }

    public OauthSettings(String secret, String consumerKey, String callbackUrl) {
        this.secret = secret;
        this.consumerKey = consumerKey;
        this.callbackUrl = callbackUrl;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OauthSettings that = (OauthSettings)o;
        if (this.callbackUrl != null ? !this.callbackUrl.equals(that.callbackUrl) : that.callbackUrl != null) {
            return false;
        }
        if (this.consumerKey != null ? !this.consumerKey.equals(that.consumerKey) : that.consumerKey != null) {
            return false;
        }
        return !(this.secret != null ? !this.secret.equals(that.secret) : that.secret != null);
    }

    public int hashCode() {
        int result = this.secret != null ? this.secret.hashCode() : 0;
        result = 31 * result + (this.consumerKey != null ? this.consumerKey.hashCode() : 0);
        result = 31 * result + (this.callbackUrl != null ? this.callbackUrl.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OauthSettings{consumerKey='" + this.consumerKey + '\'' + ", callbackUrl='" + this.callbackUrl + '\'' + '}';
    }
}

