/*
 * Decompiled with CFR 0.152.
 */
package authzadmin.shibboleth;

import authzadmin.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class ShibbolethUserDetailService
implements AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> {
    public UserDetails loadUserDetails(PreAuthenticatedAuthenticationToken authentication) throws UsernameNotFoundException {
        ShibbolethPreAuthenticatedProcessingFilter.ShibbolethPrincipal principal = (ShibbolethPreAuthenticatedProcessingFilter.ShibbolethPrincipal)authentication.getPrincipal();
        return new ShibbolethUser(principal.uid, principal.displayName);
    }

    public static class ShibbolethUser
    implements UserDetails {
        private final String uid;
        private final String displayName;

        public ShibbolethUser(String uid, String displayName) {
            this.uid = uid;
            this.displayName = displayName;
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return Collections.EMPTY_LIST;
        }

        public String getPassword() {
            return null;
        }

        public String getUsername() {
            return this.uid;
        }

        public String getUid() {
            return this.uid;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public boolean isAccountNonExpired() {
            return true;
        }

        public boolean isAccountNonLocked() {
            return true;
        }

        public boolean isCredentialsNonExpired() {
            return true;
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

