/*
 * Decompiled with CFR 0.152.
 */
package authzadmin.voot;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestOperations;

public class VootClient {
    private static final Logger logger = LoggerFactory.getLogger(VootClient.class);
    private final String vootServiceUrl;
    private final RestOperations vootService;

    public VootClient(RestOperations vootService, String vootServiceUrl) {
        this.vootService = vootService;
        this.vootServiceUrl = vootServiceUrl;
    }

    public boolean hasAccess(String allowedGroup) {
        try {
            Map group = (Map)this.vootService.getForObject(this.vootServiceUrl + "/me/groups/{allowedGroup}", Map.class, new Object[]{allowedGroup});
            logger.debug("Retrieved group: {}", (Object)group);
            return true;
        }
        catch (HttpClientErrorException e) {
            logger.error(String.format("Unauthorized access. User does not belong to the group %s", allowedGroup), (Throwable)e);
            return false;
        }
    }
}

