/*
 * Decompiled with CFR 0.152.
 */
package authzadmin;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.Resource;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.transaction.support.TransactionTemplate;

public class ClientsAndResourcesInitializer
implements ApplicationListener<ContextRefreshedEvent> {
    private final Logger LOG = LoggerFactory.getLogger(ClientsAndResourcesInitializer.class);
    private final ClientRegistrationService clientRegistrationService;
    private final Resource resource;
    private final TransactionTemplate transactionTemplate;

    public ClientsAndResourcesInitializer(ClientRegistrationService clientRegistrationService, Resource resource, TransactionTemplate transactionTemplate) {
        this.clientRegistrationService = clientRegistrationService;
        this.resource = resource;
        this.transactionTemplate = transactionTemplate;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.LOG.debug("Initializing default oAuth clients and resource-servers from {}", (Object)this.resource);
        try {
            Config config = ConfigFactory.parseReader((Reader)new InputStreamReader(this.resource.getInputStream()));
            List clients = config.getObjectList("clients");
            List resourceServers = config.getObjectList("resourceServers");
            ArrayList resourceServersAndClientsToPersist = new ArrayList();
            List preExisting = (List)this.transactionTemplate.execute(transactionStatus -> this.clientRegistrationService.listClientDetails());
            clients.forEach(clientConfigObj -> {
                List redirectUris;
                Map clientConfig = clientConfigObj.unwrapped();
                String clientId = (String)clientConfig.get("clientId");
                Optional<ClientDetails> preExistingClientDetails = this.findPreExistingClientDetails(clientId, preExisting);
                BaseClientDetails clientDetails = preExistingClientDetails.isPresent() ? (BaseClientDetails)preExistingClientDetails.get() : new BaseClientDetails(clientId, null, null, null, null);
                String secret = (String)clientConfig.get("secret");
                clientDetails.setClientSecret(secret);
                List resourceIds = (List)clientConfig.get("resourceIds");
                clientDetails.setResourceIds((Collection)resourceIds);
                List scopes = (List)clientConfig.get("scopes");
                clientDetails.setScope((Collection)scopes);
                List grantTypes = (List)clientConfig.get("grantTypes");
                clientDetails.setAuthorizedGrantTypes((Collection)grantTypes);
                String autoApprove = (String)clientConfig.get("autoApprove");
                if (autoApprove != null && Boolean.valueOf(autoApprove).booleanValue()) {
                    clientDetails.setAutoApproveScopes(Collections.singletonList("true"));
                }
                if ((redirectUris = (List)clientConfig.get("redirectUris")) != null) {
                    clientDetails.setRegisteredRedirectUri(new HashSet(redirectUris));
                }
                resourceServersAndClientsToPersist.add(clientDetails);
            });
            resourceServers.forEach(resourceServerConfigObj -> {
                Map resourceServerConfig = resourceServerConfigObj.unwrapped();
                String clientId = (String)resourceServerConfig.get("clientId");
                Optional<ClientDetails> preExistingClientDetails = this.findPreExistingClientDetails(clientId, preExisting);
                BaseClientDetails clientDetails = preExistingClientDetails.isPresent() ? (BaseClientDetails)preExistingClientDetails.get() : new BaseClientDetails(clientId, null, null, null, null);
                clientDetails.setAuthorities((Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_TOKEN_CHECKER"}));
                String secret = (String)resourceServerConfig.get("secret");
                clientDetails.setClientSecret(secret);
                clientDetails.setAuthorizedGrantTypes(Collections.emptyList());
                resourceServersAndClientsToPersist.add(clientDetails);
            });
            this.transactionTemplate.execute(transactionStatus -> {
                resourceServersAndClientsToPersist.forEach(clientDetails -> {
                    if (this.findPreExistingClientDetails(clientDetails.getClientId(), preExisting).isPresent()) {
                        this.clientRegistrationService.updateClientDetails(clientDetails);
                        this.clientRegistrationService.updateClientSecret(clientDetails.getClientId(), clientDetails.getClientSecret());
                    } else {
                        this.clientRegistrationService.addClientDetails(clientDetails);
                    }
                });
                return null;
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read configuration", e);
        }
    }

    private Optional<ClientDetails> findPreExistingClientDetails(String clientId, List<ClientDetails> preExisting) {
        return preExisting.stream().filter(preExistingClient -> preExistingClient.getClientId().equals(clientId)).findFirst();
    }
}

