/*
 * Decompiled with CFR 0.152.
 */
package authzadmin.web;

import authzadmin.web.BaseController;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/clients/{id}"})
public class DeleteController
extends BaseController {
    @Autowired
    private ClientRegistrationService clientRegistrationService;

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public String post(@PathVariable String id, RedirectAttributes redirectAttributes, HttpServletRequest request, Authentication authentication) throws UnsupportedEncodingException {
        String decoded = URLDecoder.decode(id, "UTF-8");
        this.transactionTemplate.execute(transactionStatus -> {
            this.clientRegistrationService.removeClientDetails(decoded);
            return null;
        });
        String clientType = request.getParameter("client-type");
        boolean isResourceServer = clientType != null && clientType.equals("resource-servers");
        this.notice(redirectAttributes, isResourceServer ? "delete-resource-server.success" : "delete.success", new Object[0]);
        this.LOG.info("{} {} deleted by {}", new Object[]{isResourceServer ? "Resource Server" : "Client", id, authentication.getPrincipal()});
        return isResourceServer ? "redirect:/resource-servers" : "redirect:/clients";
    }
}

