/*
 * Decompiled with CFR 0.152.
 */
package authzadmin;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.provider.ClientDetails;

public class ClientDetailsWrapper {
    public static final SimpleGrantedAuthority ROLE_TOKEN_CHECKER_AUTHORITY = new SimpleGrantedAuthority("ROLE_TOKEN_CHECKER");
    private final boolean mutable;
    private final ClientDetails clientDetails;

    public ClientDetailsWrapper(ClientDetails clientDetails, boolean mutable) {
        this.clientDetails = clientDetails;
        this.mutable = mutable;
    }

    public ClientDetails getClientDetails() {
        return this.clientDetails;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public boolean isAutoApprove() {
        return this.clientDetails.isAutoApprove("true");
    }

    public boolean isResourceServer() {
        return this.clientDetails.getAuthorities().contains(ROLE_TOKEN_CHECKER_AUTHORITY);
    }

    public boolean isClientCredentialsAllowed() {
        return this.clientDetails.getAuthorizedGrantTypes().contains("client_credentials");
    }

    public boolean isImplicitGrantAllowed() {
        return this.clientDetails.getAuthorizedGrantTypes().contains("implicit");
    }

    public boolean isRefreshTokenAllowed() {
        return this.clientDetails.getAuthorizedGrantTypes().contains("refresh_token");
    }

    public boolean isAuthorizationCodeAllowed() {
        return this.clientDetails.getAuthorizedGrantTypes().contains("authorization_code");
    }

    public String getClientIdEncoded() throws UnsupportedEncodingException {
        return URLEncoder.encode(this.getClientDetails().getClientId(), "UTF-8");
    }
}

