/*
 * Decompiled with CFR 0.152.
 */
package authzadmin.model;

import authzadmin.model.RedirectURI;
import authzadmin.model.ResourceId;
import authzadmin.model.Scope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.util.CollectionUtils;

public class OauthSettings {
    @NotNull
    @Size(min=1)
    private String secret = UUID.randomUUID().toString();
    @NotNull
    @Size(min=1)
    private String consumerKey;
    @Valid
    private List<RedirectURI> callbackUrls = new ArrayList();
    private boolean autoApprove;
    private boolean resourceServer;
    private boolean authorizationCodeAllowed;
    private boolean refreshTokenAllowed;
    private boolean implicitGrantAllowed;
    private boolean clientCredentialsAllowed;
    @Valid
    private List<Scope> scopes = new ArrayList();
    @Valid
    private List<ResourceId> resourceIds = new ArrayList();
    private boolean newClient = true;

    public OauthSettings() {
    }

    public OauthSettings(ClientDetails clientDetails) {
        this.secret = clientDetails.getClientSecret();
        this.consumerKey = clientDetails.getClientId();
        Set registeredRedirectUri = clientDetails.getRegisteredRedirectUri();
        this.callbackUrls = CollectionUtils.isEmpty((Collection)registeredRedirectUri) ? null : registeredRedirectUri.stream().map(RedirectURI::new).collect(Collectors.toList());
        Set scopes = clientDetails.getScope();
        this.scopes = CollectionUtils.isEmpty((Collection)scopes) ? null : scopes.stream().map(Scope::new).collect(Collectors.toList());
        Set resourceIds = clientDetails.getResourceIds();
        this.resourceIds = CollectionUtils.isEmpty((Collection)resourceIds) ? null : resourceIds.stream().map(ResourceId::new).collect(Collectors.toList());
        this.autoApprove = clientDetails.isAutoApprove("auto");
        Collection authorities = clientDetails.getAuthorities();
        this.resourceServer = CollectionUtils.isEmpty((Collection)authorities) ? false : authorities.stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals("ROLE_TOKEN_CHECKER"));
        this.authorizationCodeAllowed = clientDetails.getAuthorizedGrantTypes().contains("authorization_code");
        this.refreshTokenAllowed = clientDetails.getAuthorizedGrantTypes().contains("refresh_token");
        this.implicitGrantAllowed = clientDetails.getAuthorizedGrantTypes().contains("implicit");
        this.clientCredentialsAllowed = clientDetails.getAuthorizedGrantTypes().contains("client_credentials");
        this.newClient = false;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public List<RedirectURI> getCallbackUrls() {
        return this.callbackUrls;
    }

    public void setCallbackUrls(List<RedirectURI> callbackUrls) {
        this.callbackUrls = callbackUrls;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setAutoApprove(boolean autoApprove) {
        this.autoApprove = autoApprove;
    }

    public boolean isAutoApprove() {
        return this.autoApprove;
    }

    public boolean isResourceServer() {
        return this.resourceServer;
    }

    public void setResourceServer(boolean resourceServer) {
        this.resourceServer = resourceServer;
    }

    public boolean isClientCredentialsAllowed() {
        return this.clientCredentialsAllowed;
    }

    public void setClientCredentialsAllowed(boolean clientCredentialsAllowed) {
        this.clientCredentialsAllowed = clientCredentialsAllowed;
    }

    public List<Scope> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<Scope> scopes) {
        this.scopes = scopes;
    }

    public List<ResourceId> getResourceIds() {
        return this.resourceIds;
    }

    public void setResourceIds(List<ResourceId> resourceIds) {
        this.resourceIds = resourceIds;
    }

    public boolean isNewClient() {
        return this.newClient;
    }

    public void setNewClient(boolean newClient) {
        this.newClient = newClient;
    }

    public boolean isAuthorizationCodeAllowed() {
        return this.authorizationCodeAllowed;
    }

    public void setAuthorizationCodeAllowed(boolean authorizationCodeAllowed) {
        this.authorizationCodeAllowed = authorizationCodeAllowed;
    }

    public boolean isRefreshTokenAllowed() {
        return this.refreshTokenAllowed;
    }

    public void setRefreshTokenAllowed(boolean refreshTokenAllowed) {
        this.refreshTokenAllowed = refreshTokenAllowed;
    }

    public boolean isImplicitGrantAllowed() {
        return this.implicitGrantAllowed;
    }

    public void setImplicitGrantAllowed(boolean implicitGrantAllowed) {
        this.implicitGrantAllowed = implicitGrantAllowed;
    }

    public String grantTypes() {
        ArrayList<String> grantTypes = new ArrayList<String>();
        if (this.authorizationCodeAllowed) {
            grantTypes.add("authorization_code");
        }
        if (this.refreshTokenAllowed) {
            grantTypes.add("refresh_token");
        }
        if (this.implicitGrantAllowed) {
            grantTypes.add("implicit");
        }
        if (this.clientCredentialsAllowed) {
            grantTypes.add("client_credentials");
        }
        return String.join((CharSequence)",", grantTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OauthSettings that = (OauthSettings)o;
        return Objects.equals(this.consumerKey, that.consumerKey);
    }

    public int hashCode() {
        return Objects.hash(this.consumerKey);
    }
}

