/*
 * Decompiled with CFR 0.152.
 */
package authzadmin.web;

import authzadmin.OauthClientDetails;
import authzadmin.model.ClientValidator;
import authzadmin.model.OauthSettings;
import authzadmin.web.BaseController;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientRegistrationService;
import org.springframework.security.oauth2.provider.client.JdbcClientDetailsService;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class ClientController
extends BaseController {
    @Autowired
    private ClientRegistrationService clientRegistrationService;
    private ClientValidator clientValidator = new ClientValidator();

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public ModelAndView get(OauthSettings oauthSettings) {
        return new ModelAndView("create", "oauthSettings", (Object)oauthSettings);
    }

    @RequestMapping(value={"/create-resource-server"}, method={RequestMethod.GET})
    public ModelAndView createResourceServer(OauthSettings oauthSettings) {
        oauthSettings.setResourceServer(true);
        oauthSettings.setAuthorizationCodeAllowed(false);
        oauthSettings.setRefreshTokenAllowed(false);
        return new ModelAndView("create-resource-server", "oauthSettings", (Object)oauthSettings);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String post(@Valid OauthSettings oauthSettings, BindingResult bindingResult, RedirectAttributes redirectAttributes) {
        if (this.clientValidator.hasErrors(oauthSettings, bindingResult)) {
            return oauthSettings.isResourceServer() ? "create-resource-server" : "create";
        }
        try {
            this.transactionTemplate.execute(transactionStatus -> {
                this.clientRegistrationService.addClientDetails((ClientDetails)new OauthClientDetails(oauthSettings));
                return null;
            });
            this.notice(redirectAttributes, "create.success", new Object[0]);
            return oauthSettings.isResourceServer() ? "redirect:/resource-servers" : "redirect:/clients";
        }
        catch (ClientAlreadyExistsException e) {
            bindingResult.rejectValue("consumerKey", "create.clientAlreadyExists");
            return oauthSettings.isResourceServer() ? "create-resource-server" : "create";
        }
    }

    @RequestMapping(value={"/clients/{id}/edit"}, method={RequestMethod.POST})
    public ModelAndView edit(@PathVariable(value="id") String id) throws UnsupportedEncodingException {
        return this.doEdit(id, "create");
    }

    @RequestMapping(value={"/clients/{id}/edit-resource-server"}, method={RequestMethod.POST})
    public ModelAndView editResourceServer(@PathVariable(value="id") String id) throws UnsupportedEncodingException {
        return this.doEdit(id, "create-resource-server");
    }

    private ModelAndView doEdit(String id, String viewName) throws UnsupportedEncodingException {
        String decodedId = URLDecoder.decode(id, "UTF-8");
        ClientDetails clientDetails = ((JdbcClientDetailsService)this.clientRegistrationService).loadClientByClientId(decodedId);
        return new ModelAndView(viewName, "oauthSettings", (Object)new OauthSettings(clientDetails));
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public String update(@Valid OauthSettings oauthSettings, BindingResult bindingResult, RedirectAttributes redirectAttributes) {
        if (this.clientValidator.hasErrors(oauthSettings, bindingResult)) {
            return oauthSettings.isResourceServer() ? "create-resource-server" : "create";
        }
        this.transactionTemplate.execute(transactionStatus -> {
            this.clientRegistrationService.updateClientDetails((ClientDetails)new OauthClientDetails(oauthSettings));
            return null;
        });
        this.notice(redirectAttributes, oauthSettings.isResourceServer() ? "create-resource-server.success" : "edit.success", new Object[0]);
        return oauthSettings.isResourceServer() ? "redirect:/resource-servers" : "redirect:/clients";
    }

    @RequestMapping(value={"/clients/{id}/reset"}, method={RequestMethod.POST})
    public String reset(@PathVariable String id, RedirectAttributes redirectAttributes, HttpServletRequest request) throws UnsupportedEncodingException {
        String decoded = URLDecoder.decode(id, "UTF-8");
        String newSecret = UUID.randomUUID().toString();
        this.transactionTemplate.execute(transactionStatus -> {
            this.clientRegistrationService.updateClientSecret(decoded, newSecret);
            return null;
        });
        this.notice(redirectAttributes, "reset.success", newSecret);
        String clientType = request.getParameter("client-type");
        return clientType != null && clientType.equals("resource-servers") ? "redirect:/resource-servers" : "redirect:/clients";
    }
}

