/*
 * Decompiled with CFR 0.152.
 */
package authzadmin;

import authzadmin.voot.VootClient;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.web.client.RestOperations;

@Configuration
public class VootClientConfig {
    @Value(value="${voot.accessTokenUri}")
    private String accessTokenUri;
    @Value(value="${voot.userAuthorizationUri}")
    private String userAuthorizationUri;
    @Value(value="${voot.clientId}")
    private String clientId;
    @Value(value="${voot.clientSecret}")
    private String clientSecret;
    @Value(value="${voot.redirectUri}")
    private String redirectUri;
    @Value(value="${voot.scopes}")
    private String spaceDelimitedScopes;

    @Bean
    public OAuth2ProtectedResourceDetails voot() {
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        details.setId("voot");
        details.setClientId(this.clientId);
        details.setClientSecret(this.clientSecret);
        details.setAccessTokenUri(this.accessTokenUri);
        details.setUserAuthorizationUri(this.userAuthorizationUri);
        details.setUseCurrentUri(false);
        details.setScope(Arrays.asList(this.spaceDelimitedScopes.split(" ")));
        return details;
    }

    @Bean
    public OAuth2RestTemplate vootRestTemplate(OAuth2ClientContext context) {
        return new OAuth2RestTemplate(this.voot(), context);
    }

    @Bean
    @Profile(value={"!dev"})
    public VootClient vootClient(OAuth2RestTemplate vootService, @Value(value="${voot.serviceUrl}") String vootServiceUrl) {
        return new VootClient((RestOperations)vootService, vootServiceUrl);
    }

    @Bean
    @Profile(value={"dev"})
    public VootClient mockVootClient(OAuth2RestTemplate vootService, @Value(value="${voot.serviceUrl}") String vootServiceUrl) {
        return new VootClient((RestOperations)vootService, vootServiceUrl){

            @Override
            public boolean hasAccess(String allowedGroup) {
                return true;
            }
        };
    }
}

