/*
 * Decompiled with CFR 0.152.
 */
package authzplay.web;

import authzplay.ClientSettings;
import authzplay.JWKVerifier;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.PartialRequestBuilder;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.core.header.OutBoundHeaders;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Configuration
public class ClientController {
    @Value(value="${oauth.redirect_uri}")
    private String redirectUri;
    @Value(value="${oauth.token_uri}")
    private String tokenUri;
    @Value(value="${oauth.client_id}")
    private String clientId;
    @Value(value="${oauth.client_secret}")
    private String clientSecret;
    @Value(value="${oauth.authorize_url}")
    private String authorizeUrl;
    @Value(value="${oauth.resource_server_api_url}")
    private String resourceServerApiUrl;
    @Value(value="${oauth.check_token_url}")
    private String checkTokenUrl;
    @Value(value="${oauth.scopes}")
    private String scopes;
    @Value(value="${oidc.redirect_uri}")
    private String oidcRedirectUri;
    @Value(value="${oidc.token_uri}")
    private String oidcTokenUri;
    @Value(value="${oidc.client_id}")
    private String oidcClientId;
    @Value(value="${oidc.client_secret}")
    private String oidcClientSecret;
    @Value(value="${oidc.scopes}")
    private String oidcScopes;
    @Value(value="${oidc.authorize_url}")
    private String oidcAuthorizeUrl;
    @Value(value="${oidc.resource_server_api_url}")
    private String oidcResourceServerApiUrl;
    @Value(value="${oidc.introspect_url}")
    private String oidcIntrospectUrl;
    @Value(value="${oidc.user_info_url}")
    private String oidcUserInfoUrl;
    @Value(value="${oidc.jwk_url}")
    private String oidcJwkUrl;
    @Value(value="${oidc.well_known_configuration_url}")
    private String oidcWellKnownConfigurationUrl;
    private static final String AUTHORIZATION = "Authorization";
    private static final String SETTINGS = "settings";
    private static final String BR = System.getProperty("line.separator");
    private static final ObjectMapper mapper = new ObjectMapper();
    private Client client;

    public ClientController() {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(JacksonJsonProvider.class);
        this.client = Client.create((ClientConfig)config);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String start(ModelMap modelMap, @RequestParam(value="modus", defaultValue="oauth2", required=false) String modus) throws IOException {
        ClientSettings settings = this.createDefaultSettings(modus);
        modelMap.addAttribute(SETTINGS, (Object)settings);
        return "oauth-client";
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"reset"})
    public String reset(ModelMap modelMap) throws IOException {
        return this.start(modelMap, "oauth2");
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"step1"})
    public String step1(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings, HttpServletRequest request, HttpServletResponse response) throws IOException, ParseException {
        if (settings.getGrantType().equals("clientCredentials")) {
            settings.setStep("step3");
            request.getSession().setAttribute(SETTINGS, (Object)settings);
            this.redirect(modelMap, request, response);
        } else {
            settings.setStep("step2");
            String responseTypeFromClient = settings.getResponseType();
            boolean implicit = settings.getGrantType().equals("implicit");
            String responseType = !implicit && StringUtils.hasText((String)responseTypeFromClient) ? responseTypeFromClient : (implicit ? "token" : "code");
            String encodedScopes = URLEncoder.encode(settings.getOauthScopes(), "UTF-8");
            String authorizationUrlComplete = String.format(settings.getAuthorizationURL().concat("?response_type=%s&client_id=%s&scope=%s&state=example"), responseType, settings.getOauthKey(), encodedScopes);
            if (!settings.isNoRedirectUri()) {
                authorizationUrlComplete = authorizationUrlComplete + "&redirect_uri=" + this.redirectUri;
            }
            settings.setAuthorizationURLComplete(authorizationUrlComplete);
        }
        modelMap.addAttribute(SETTINGS, (Object)settings);
        return "oauth-client";
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"step2"})
    public void step2(@ModelAttribute(value="settings") ClientSettings settings, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.getSession().setAttribute(SETTINGS, (Object)settings);
        String authorizationURLComplete = settings.getAuthorizationURLComplete();
        response.sendRedirect(authorizationURLComplete);
    }

    @RequestMapping(value={"redirect"}, method={RequestMethod.GET})
    public String redirect(ModelMap modelMap, HttpServletRequest request, HttpServletResponse response) throws IOException, ParseException {
        ClientSettings settings = (ClientSettings)request.getSession().getAttribute(SETTINGS);
        String responseType = settings.getResponseType();
        if (settings.getGrantType().equals("implicit")) {
            modelMap.addAttribute("parseAnchorForAccessToken", (Object)Boolean.TRUE);
            if (settings.isOpenIdConnect()) {
                modelMap.addAttribute("parseAnchorForIdToken", (Object)Boolean.TRUE);
            }
        } else if (StringUtils.hasText((String)responseType) && responseType.equals("id_token")) {
            modelMap.addAttribute("parseAnchorForIdToken", (Object)Boolean.TRUE);
        } else {
            MultivaluedMapImpl formData = new MultivaluedMapImpl();
            boolean isClientCredentials = settings.getGrantType().equals("clientCredentials");
            formData.add((Object)"grant_type", (Object)(isClientCredentials ? "client_credentials" : "authorization_code"));
            if (!isClientCredentials) {
                String code = request.getParameter("code");
                formData.add((Object)"code", (Object)code);
            }
            formData.add((Object)"redirect_uri", (Object)this.redirectUri);
            WebResource.Builder builder = this.getBasicAuthBuilder(settings, settings.getAccessTokenEndPoint());
            OutBoundHeaders headers = this.getHeadersCopy(builder);
            ClientResponse clientResponse = (ClientResponse)builder.post(ClientResponse.class, (Object)formData);
            this.addResponseInfo(modelMap, clientResponse);
            String json = new String(FileCopyUtils.copyToByteArray((InputStream)clientResponse.getEntityInputStream()));
            modelMap.put((Object)"rawResponseInfo", (Object)this.getRawResponseInfo(json));
            modelMap.put((Object)"requestInfo", (Object)"Method: POST".concat(BR).concat("URL: ").concat(settings.getAccessTokenEndPoint()).concat(BR).concat("Headers: ").concat(headers.toString()).concat(BR).concat("Body: ").concat(formData.toString()));
            if (clientResponse.getStatus() == 200) {
                HashMap map = (HashMap)mapper.readValue(json, HashMap.class);
                settings.setAccessToken((String)map.get("access_token"));
                if (settings.isOpenIdConnect()) {
                    settings.setAccessTokenJson(this.parseJWT(settings.getAccessToken()));
                    if (map.containsKey("id_token")) {
                        settings.setIdToken((String)map.get("id_token"));
                        settings.setIdTokenJson(this.parseJWT(settings.getIdToken()));
                    }
                }
            }
        }
        modelMap.put((Object)SETTINGS, (Object)settings);
        settings.setStep("step3");
        return "oauth-client";
    }

    private String getRawResponseInfo(String json) throws IOException {
        JsonNode jsonNode = mapper.readTree(json);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"step3"})
    public String step3(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings) throws IOException {
        String requestURL = settings.getRequestURL();
        String accessToken = settings.getAccessToken();
        return this.performResourceCall(modelMap, settings, requestURL, accessToken);
    }

    private String performResourceCall(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings, String requestURL, String accessToken) throws IOException {
        accessToken = accessToken.replace("!", "\\!");
        WebResource.Builder builder = (WebResource.Builder)((WebResource.Builder)this.client.resource(requestURL).header(AUTHORIZATION, (Object)"bearer ".concat(accessToken)).type(MediaType.APPLICATION_JSON_TYPE)).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        return this.doPerformCall(modelMap, settings, requestURL, builder, HttpMethod.GET, null);
    }

    private String doPerformCall(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings, String requestURL, WebResource.Builder builder, HttpMethod method, Object requestEntity) throws IOException {
        ClientResponse clientResponse;
        OutBoundHeaders headers = this.getHeadersCopy(builder);
        long start = System.currentTimeMillis();
        if (method.equals((Object)HttpMethod.GET)) {
            clientResponse = (ClientResponse)builder.get(ClientResponse.class);
        } else if (method.equals((Object)HttpMethod.POST)) {
            clientResponse = (ClientResponse)builder.post(ClientResponse.class, requestEntity);
        } else {
            throw new RuntimeException("Not supported method: " + method);
        }
        String json = IOUtils.toString((InputStream)clientResponse.getEntityInputStream());
        settings.setStep("step3");
        modelMap.put((Object)SETTINGS, (Object)settings);
        modelMap.put((Object)"requestInfo", (Object)"Method: ".concat(method.name()).concat(BR).concat("URL: ").concat(requestURL).concat(BR).concat("Headers: ").concat(headers.toString()));
        this.addResponseInfo(modelMap, clientResponse);
        modelMap.put((Object)"responseTime", (Object)String.format("Took %s ms", System.currentTimeMillis() - start));
        modelMap.put((Object)"rawResponseInfo", (Object)this.getRawResponseInfo(json));
        return "oauth-client";
    }

    private String doPerformGet(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings, String requestURL, WebResource.Builder builder) throws IOException {
        return this.doPerformCall(modelMap, settings, requestURL, builder, HttpMethod.GET, null);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"userInfo"})
    public String userInfo(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings) throws IOException {
        String accessToken = settings.getAccessToken();
        return this.performResourceCall(modelMap, settings, this.oidcUserInfoUrl, accessToken);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"introspect"})
    public String introspect(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings) throws IOException {
        String accessToken = settings.getAccessToken();
        String requestURL = this.oidcIntrospectUrl + "?token=" + accessToken;
        WebResource.Builder builder = this.getBasicAuthBuilder(settings, requestURL);
        return this.doPerformGet(modelMap, settings, requestURL, builder);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"checkToken"})
    public String checkToken(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings) throws IOException {
        String accessToken = settings.getAccessToken();
        WebResource.Builder builder = this.getBasicAuthBuilder(settings, this.checkTokenUrl);
        Form formData = new Form();
        formData.put((Object)"token", Collections.singletonList(accessToken));
        return this.doPerformCall(modelMap, settings, this.checkTokenUrl, builder, HttpMethod.POST, formData);
    }

    @RequestMapping(value={"/decodeJwtToken"}, method={RequestMethod.GET})
    @ResponseBody
    public String decodeJwtToken(@RequestParam String jwtToken) throws IOException, ParseException {
        return this.parseJWT(jwtToken);
    }

    private WebResource.Builder getBasicAuthBuilder(ClientSettings settings, String requestURL) {
        String auth = "Basic ".concat(new String(Base64.encodeBase64((byte[])settings.getOauthKey().concat(":").concat(settings.getOauthSecret()).getBytes())));
        return (WebResource.Builder)this.client.resource(requestURL).header(AUTHORIZATION, (Object)auth).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
    }

    private void addResponseInfo(ModelMap modelMap, ClientResponse clientResponse) {
        modelMap.put((Object)"responseInfo", (Object)"Status: ".concat(String.valueOf(clientResponse.getStatus()).concat(BR).concat("Headers:").concat(clientResponse.getHeaders().toString())));
    }

    private OutBoundHeaders getHeadersCopy(WebResource.Builder builder) {
        try {
            Field metaData = PartialRequestBuilder.class.getDeclaredField("metadata");
            metaData.setAccessible(true);
            return new OutBoundHeaders((OutBoundHeaders)metaData.get(builder));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String parseJWT(String jwtToken) throws IOException, ParseException {
        JWKVerifier verifier = new JWKVerifier(jwtToken);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(verifier.toMap());
    }

    protected ClientSettings createDefaultSettings(String modus) {
        ClientSettings settings;
        if ("oauth2".equalsIgnoreCase(modus)) {
            settings = new ClientSettings(this.tokenUri, this.clientId, this.clientSecret, this.authorizeUrl, "step1", this.resourceServerApiUrl, this.scopes);
        } else {
            settings = new ClientSettings(this.oidcTokenUri, this.oidcClientId, this.oidcClientSecret, this.oidcAuthorizeUrl, "step1", this.oidcResourceServerApiUrl, this.oidcScopes);
            settings.setOpenIdConnect(true);
            settings.setOidcIntrospectUrl(this.oidcIntrospectUrl);
            settings.setOidcJwkUrl(this.oidcJwkUrl);
            settings.setOidcUserInfoUrl(this.oidcUserInfoUrl);
            settings.setOidcWellKnownConfigurationUrl(this.oidcWellKnownConfigurationUrl);
        }
        settings.setGrantType("authCode");
        settings.setResponseType("code");
        return settings;
    }
}

