/*
 * Decompiled with CFR 0.152.
 */
package authzplay;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

public class JWKVerifier {
    private final SignedJWT signedJWT;

    public JWKVerifier(String token) throws ParseException {
        this.signedJWT = SignedJWT.parse((String)token);
    }

    public JWSHeader header() {
        return this.signedJWT.getHeader();
    }

    public JWTClaimsSet claims() throws ParseException {
        return this.signedJWT.getJWTClaimsSet();
    }

    public Map<String, Map<String, Object>> toMap() throws ParseException {
        JWSHeader header = this.header();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("kid", header.getKeyID());
        headerMap.put("alg", header.getAlgorithm().getName());
        Map claims = this.claims().getClaims();
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        result.put("header", headerMap);
        result.put("payload", claims);
        return result;
    }
}

