/*
 * Decompiled with CFR 0.152.
 */
package authzplay.web;

import authzplay.ClientSettings;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.PartialRequestBuilder;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.core.header.OutBoundHeaders;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Configuration
public class ClientController {
    @Value(value="${oauth.redirect_uri}")
    private String redirectUri;
    @Value(value="${oauth.token_uri}")
    private String tokenUri;
    @Value(value="${oauth.client_id}")
    private String clientId;
    @Value(value="${oauth.client_secret}")
    private String clientSecret;
    @Value(value="${oauth.authorize_url}")
    private String authorizeUrl;
    @Value(value="${oauth.resource_server_api_url}")
    private String resourceServerApiUrl;
    @Value(value="${oauth.scopes}")
    private String scopes;
    private static final String AUTHORIZATION = "Authorization";
    private static final String SETTINGS = "settings";
    private static final String BR = System.getProperty("line.separator");
    private static final ObjectMapper mapper = new ObjectMapper();
    private Client client;

    public ClientController() {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(JacksonJsonProvider.class);
        this.client = Client.create((ClientConfig)config);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String start(ModelMap modelMap, HttpServletRequest request, HttpServletResponse response) throws IOException {
        modelMap.addAttribute(SETTINGS, (Object)this.createDefaultSettings());
        return "oauth-client";
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"reset"})
    public String reset(ModelMap modelMap, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.start(modelMap, request, response);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"step1"})
    public String step1(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (settings.getGrantType().equals("clientCredentials")) {
            settings.setStep("step3");
            request.getSession().setAttribute(SETTINGS, (Object)settings);
            this.redirect(modelMap, request, response);
        } else {
            settings.setStep("step2");
            String responseType = settings.getGrantType().equals("implicit") ? "token" : "code";
            String encodedScopes = URLEncoder.encode(settings.getOauthScopes(), "UTF-8");
            String authorizationUrlComplete = String.format(settings.getAuthorizationURL().concat("?response_type=%s&client_id=%s&scope=%s&state=example"), responseType, settings.getOauthKey(), encodedScopes);
            if (!settings.isNoRedirectUri()) {
                authorizationUrlComplete = authorizationUrlComplete + "&redirect_uri=" + this.redirectUri;
            }
            settings.setAuthorizationURLComplete(authorizationUrlComplete);
        }
        modelMap.addAttribute(SETTINGS, (Object)settings);
        return "oauth-client";
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"step2"})
    public void step2(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings, HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.getSession().setAttribute(SETTINGS, (Object)settings);
        String authorizationURLComplete = settings.getAuthorizationURLComplete();
        response.sendRedirect(authorizationURLComplete);
    }

    @RequestMapping(value={"redirect"}, method={RequestMethod.GET})
    public String redirect(ModelMap modelMap, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ClientSettings settings = (ClientSettings)request.getSession().getAttribute(SETTINGS);
        if (settings.getGrantType().equals("implicit")) {
            modelMap.addAttribute("parseAnchorForAccessToken", (Object)Boolean.TRUE);
        } else {
            MultivaluedMapImpl formData = new MultivaluedMapImpl();
            boolean isClientCredentials = settings.getGrantType().equals("clientCredentials");
            formData.add((Object)"grant_type", (Object)(isClientCredentials ? "client_credentials" : "authorization_code"));
            if (!isClientCredentials) {
                String code = request.getParameter("code");
                formData.add((Object)"code", (Object)code);
            }
            formData.add((Object)"redirect_uri", (Object)this.redirectUri);
            String auth = "Basic ".concat(new String(Base64.encodeBase64((byte[])settings.getOauthKey().concat(":").concat(settings.getOauthSecret()).getBytes())));
            WebResource.Builder builder = (WebResource.Builder)this.client.resource(settings.getAccessTokenEndPoint()).header(AUTHORIZATION, (Object)auth).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE);
            OutBoundHeaders headers = this.getHeadersCopy(builder);
            ClientResponse clientResponse = (ClientResponse)builder.post(ClientResponse.class, (Object)formData);
            this.addResponseInfo(modelMap, clientResponse);
            String json = new String(FileCopyUtils.copyToByteArray((InputStream)clientResponse.getEntityInputStream()));
            modelMap.put((Object)"rawResponseInfo", (Object)json);
            modelMap.put((Object)"requestInfo", (Object)"Method: POST".concat(BR).concat("URL: ").concat(settings.getAccessTokenEndPoint()).concat(BR).concat("Headers: ").concat(headers.toString()).concat(BR).concat("Body: ").concat(formData.toString()));
            if (clientResponse.getStatus() == 200) {
                HashMap map = (HashMap)mapper.readValue(json, HashMap.class);
                settings.setAccessToken((String)map.get("access_token"));
            }
        }
        modelMap.put((Object)SETTINGS, (Object)settings);
        settings.setStep("step3");
        return "oauth-client";
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST}, params={"step3"})
    public String step3(ModelMap modelMap, @ModelAttribute(value="settings") ClientSettings settings, HttpServletRequest request, HttpServletResponse response) throws IOException {
        WebResource.Builder builder = (WebResource.Builder)((WebResource.Builder)this.client.resource(settings.getRequestURL()).header(AUTHORIZATION, (Object)"bearer ".concat(settings.getAccessToken())).type(MediaType.APPLICATION_JSON_TYPE)).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        OutBoundHeaders headers = this.getHeadersCopy(builder);
        long start = System.currentTimeMillis();
        ClientResponse clientResponse = (ClientResponse)builder.get(ClientResponse.class);
        String json = IOUtils.toString((InputStream)clientResponse.getEntityInputStream());
        settings.setStep("step3");
        modelMap.put((Object)SETTINGS, (Object)settings);
        modelMap.put((Object)"requestInfo", (Object)"Method: GET".concat(BR).concat("URL: ").concat(settings.getRequestURL()).concat(BR).concat("Headers: ").concat(headers.toString()));
        this.addResponseInfo(modelMap, clientResponse);
        modelMap.put((Object)"responseTime", (Object)String.format("Took %s ms", System.currentTimeMillis() - start));
        modelMap.put((Object)"rawResponseInfo", (Object)json);
        return "oauth-client";
    }

    private void addResponseInfo(ModelMap modelMap, ClientResponse clientResponse) {
        modelMap.put((Object)"responseInfo", (Object)"Status: ".concat(String.valueOf(clientResponse.getStatus()).concat(BR).concat("Headers:").concat(clientResponse.getHeaders().toString())));
    }

    private OutBoundHeaders getHeadersCopy(WebResource.Builder builder) {
        try {
            Field metaData = PartialRequestBuilder.class.getDeclaredField("metadata");
            metaData.setAccessible(true);
            return new OutBoundHeaders((OutBoundHeaders)metaData.get(builder));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ClientSettings createDefaultSettings() {
        ClientSettings settings = new ClientSettings(this.tokenUri, this.clientId, this.clientSecret, this.authorizeUrl, "step1", this.resourceServerApiUrl, this.scopes);
        settings.setGrantType("authCode");
        return settings;
    }
}

