/*
 * Decompiled with CFR 0.152.
 */
package authzserver.shibboleth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final String COLLAB_PERSON_ID_HEADER_NAME = "name-id";
    public static final String SCHAC_HOME_ORGANIZATION_HEADER_NAME = "schachomeorganization";
    public static final String DISPLAY_NAME_HEADER_NAME = "displayname";
    public static final String PERSISTENT_NAME_ID_PREFIX = "urn:collab:person:";
    public static final String SHIB_AUTHENTICATING_AUTHORITY = "Shib-Authenticating-Authority";
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
    private static final String EMPTY_HEADER_ERROR_TEMPLATE = "Header '%s' must be set";

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager) {
        this.setAuthenticationManager(authenticationManager);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String uid = request.getHeader(COLLAB_PERSON_ID_HEADER_NAME);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (String)EMPTY_HEADER_ERROR_TEMPLATE, (Object[])new Object[]{COLLAB_PERSON_ID_HEADER_NAME});
        Preconditions.checkArgument((boolean)uid.startsWith(PERSISTENT_NAME_ID_PREFIX), (String)"Header '%s' must start with '%s'. Actual value is '%'", (Object[])new Object[]{COLLAB_PERSON_ID_HEADER_NAME, PERSISTENT_NAME_ID_PREFIX, uid});
        String schacHomeOrganization = request.getHeader(SCHAC_HOME_ORGANIZATION_HEADER_NAME);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schacHomeOrganization) ? 1 : 0) != 0, (String)EMPTY_HEADER_ERROR_TEMPLATE, (Object[])new Object[]{SCHAC_HOME_ORGANIZATION_HEADER_NAME});
        String email = request.getHeader("Shib-InetOrgPerson-mail");
        String displayName = request.getHeader(DISPLAY_NAME_HEADER_NAME);
        String authenticatingAuthorities = request.getHeader(SHIB_AUTHENTICATING_AUTHORITY);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)authenticatingAuthorities) ? 1 : 0) != 0, (String)EMPTY_HEADER_ERROR_TEMPLATE, (Object[])new Object[]{SHIB_AUTHENTICATING_AUTHORITY});
        String authenticatingAuthority = authenticatingAuthorities.split(";")[0];
        ShibbolethPrincipal shibbolethPrincipal = new ShibbolethPrincipal(uid, schacHomeOrganization, displayName, authenticatingAuthority, email);
        LOG.debug("Assembled Shibboleth principal from headers: {}", (Object)shibbolethPrincipal);
        return shibbolethPrincipal;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    public static final class ShibbolethPrincipal {
        public final String username;
        public final String schacHomeOrganization;
        public final String displayName;
        public final String authenticatingAuthority;
        public final String email;

        public ShibbolethPrincipal(String username, String schacHomeOrganization, String displayName, String authenticatingAuthority, String email) {
            this.username = username;
            this.schacHomeOrganization = schacHomeOrganization;
            this.displayName = displayName;
            this.authenticatingAuthority = authenticatingAuthority;
            this.email = email;
        }

        public String toString() {
            return "ShibbolethPrincipal{username='" + this.username + '\'' + ", schacHomeOrganization='" + this.schacHomeOrganization + '\'' + ", displayName='" + this.displayName + '\'' + ", authenticatingAuthority='" + this.authenticatingAuthority + '\'' + ", email='" + this.email + '\'' + '}';
        }
    }
}

