/*
 * Decompiled with CFR 0.152.
 */
package authzserver.shibboleth;

import authzserver.shibboleth.ShibbolethUser;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final String SHIB_NAME_ID_HEADER_NAME = "name-id";
    public static final String SHIB_SCHAC_HOME_ORGANIZATION_HEADER_NAME = "schachomeorganization";
    public static final String SHIB_AUTHENTICATING_AUTHORITY = "Shib-Authenticating-Authority";
    public static final String SHIB_EMAIL = "Shib-InetOrgPerson-mail";
    public static final String SHIB_DISPLAY_NAME = "displayName";
    public static final String SHIB_EDU_PERSON_PRINCIPAL_NAME = "eduPersonPrincipalName";
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
    private static final String EMPTY_HEADER_ERROR_TEMPLATE = "Header '%s' must be set";

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager) {
        this.setAuthenticationManager(authenticationManager);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String uid = this.getHeader(SHIB_NAME_ID_HEADER_NAME, request);
        if (StringUtils.isEmpty((Object)uid)) {
            throw new PreAuthenticatedCredentialsNotFoundException(String.format(EMPTY_HEADER_ERROR_TEMPLATE, SHIB_NAME_ID_HEADER_NAME));
        }
        String schacHomeOrganization = this.getHeader(SHIB_SCHAC_HOME_ORGANIZATION_HEADER_NAME, request);
        if (StringUtils.isEmpty((Object)schacHomeOrganization)) {
            throw new PreAuthenticatedCredentialsNotFoundException(String.format(EMPTY_HEADER_ERROR_TEMPLATE, SHIB_SCHAC_HOME_ORGANIZATION_HEADER_NAME));
        }
        String authenticatingAuthorities = this.getHeader(SHIB_AUTHENTICATING_AUTHORITY, request);
        if (StringUtils.isEmpty((Object)authenticatingAuthorities)) {
            throw new PreAuthenticatedCredentialsNotFoundException(String.format(EMPTY_HEADER_ERROR_TEMPLATE, SHIB_AUTHENTICATING_AUTHORITY));
        }
        String authenticatingAuthority = authenticatingAuthorities.split(";")[0];
        String email = this.getHeader(SHIB_EMAIL, request);
        String displayName = this.getHeader(SHIB_DISPLAY_NAME, request);
        String eduPersonPrincipalName = this.getHeader(SHIB_EDU_PERSON_PRINCIPAL_NAME, request);
        ShibbolethUser user = new ShibbolethUser(uid, eduPersonPrincipalName, schacHomeOrganization, displayName, authenticatingAuthority, email);
        LOG.debug("Assembled Shibboleth user from headers: {}", (Object)user);
        return user;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }

    private String getHeader(String name, HttpServletRequest request) {
        String header = request.getHeader(name);
        try {
            return StringUtils.hasText((String)header) ? new String(header.getBytes("ISO8859-1"), "UTF-8") : header;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

