/*
 * Decompiled with CFR 0.152.
 */
package authzserver.web;

import authzserver.model.Attribute;
import authzserver.model.LifeCycleResult;
import authzserver.shibboleth.ShibbolethUser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserLifeCycleController {
    private static final Logger LOG = LoggerFactory.getLogger(UserLifeCycleController.class);
    private NamedParameterJdbcTemplate jdbcTemplate;

    @Autowired
    public UserLifeCycleController(DataSource dataSource) {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/deprovision/{userId:.+}"})
    public LifeCycleResult preview(@PathVariable String userId, Authentication authentication) {
        LOG.info("Request for lifecycle preview for {} by {}", (Object)userId, authentication.getPrincipal());
        return this.doDryRun(userId, true);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/deprovision/{userId:.+}/dry-run"})
    public LifeCycleResult dryRun(@PathVariable String userId, Authentication authentication) {
        LOG.info("Request for lifecycle dry-run for {} by {}", (Object)userId, authentication.getPrincipal());
        return this.doDryRun(userId, true);
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/deprovision/{userId:.+}"})
    @Transactional
    public LifeCycleResult deprovision(@PathVariable String userId, Authentication authentication) {
        LOG.info("Request for lifecycle deprovision for {} by {}", (Object)userId, authentication.getPrincipal());
        return this.doDryRun(userId, false);
    }

    private LifeCycleResult doDryRun(String userId, boolean dryRun) {
        LifeCycleResult result = new LifeCycleResult();
        HashSet attributes = new HashSet();
        Map<String, String> paramMap = Collections.singletonMap("user_name", userId);
        ArrayList refreshTokens = new ArrayList();
        this.jdbcTemplate.query("select authentication, refresh_token from oauth_access_token where user_name = :user_name", paramMap, rs -> {
            OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)SerializationUtils.deserialize((byte[])rs.getBytes(1));
            this.addUserAttributes(attributes, oAuth2Authentication);
            refreshTokens.add(rs.getString(2));
        });
        if (!refreshTokens.isEmpty()) {
            this.jdbcTemplate.query("select authentication from oauth_refresh_token where token_id in (:tokens)", Collections.singletonMap("tokens", refreshTokens), rs -> {
                OAuth2Authentication oAuth2Authentication = (OAuth2Authentication)SerializationUtils.deserialize((byte[])rs.getBytes(1));
                this.addUserAttributes(attributes, oAuth2Authentication);
            });
        }
        this.jdbcTemplate.query("select clientId, scope, status from oauth_approvals where userId = :user_name", paramMap, rs -> attributes.add(new Attribute("approval", rs.getString(1) + "_" + rs.getString(2) + "_" + rs.getString(3))));
        if (!dryRun) {
            int update = this.jdbcTemplate.update("delete from oauth_approvals where userId = :user_name", paramMap);
            LOG.info("Removed {} oauth_approvals for user {}", (Object)update, (Object)userId);
            if (!refreshTokens.isEmpty()) {
                update = this.jdbcTemplate.update("delete from oauth_refresh_token where token_id in (:tokens)", Collections.singletonMap("tokens", refreshTokens));
                LOG.info("Removed {} oauth_refresh_token for user {}", (Object)update, (Object)userId);
            }
            update = this.jdbcTemplate.update("delete from oauth_access_token where user_name = :user_name", paramMap);
            LOG.info("Removed {} oauth_access_token for user {}", (Object)update, (Object)userId);
        }
        result.setData(new ArrayList(attributes).stream().filter(attr -> StringUtils.hasText((String)attr.getValue())).sorted(Comparator.comparing(Attribute::getName)).collect(Collectors.toList()));
        return result;
    }

    private void addUserAttributes(Set<Attribute> attributes, OAuth2Authentication oAuth2Authentication) {
        ShibbolethUser user = (ShibbolethUser)ShibbolethUser.class.cast(oAuth2Authentication.getPrincipal());
        attributes.add(new Attribute("authenticating_authority", user.getAuthenticatingAuthority()));
        attributes.add(new Attribute("display_name", user.getDisplayName()));
        attributes.add(new Attribute("edu_person_principal_name", user.getEduPersonPrincipalName()));
        attributes.add(new Attribute("email", user.getEmail()));
        attributes.add(new Attribute("schac_home_organisation", user.getSchacHomeOrganization()));
        attributes.add(new Attribute("user_name", user.getUsername()));
    }
}

