/*
 * Decompiled with CFR 0.152.
 */
package authzserver;

import java.util.Collections;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LifeCycleAPIAuthenticationManager
implements AuthenticationManager {
    private String apiLifeCycleUsername;
    private String apiLifeCyclePassword;

    public LifeCycleAPIAuthenticationManager(String apiLifeCycleUsername, String apiLifeCyclePassword) {
        this.apiLifeCycleUsername = apiLifeCycleUsername;
        this.apiLifeCyclePassword = apiLifeCyclePassword;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String name = (String)String.class.cast(authentication.getPrincipal());
        if (!name.equals(this.apiLifeCycleUsername)) {
            throw new UsernameNotFoundException("Unknown user: " + name);
        }
        if (!authentication.getCredentials().equals(this.apiLifeCyclePassword)) {
            throw new BadCredentialsException("Bad credentials");
        }
        return new UsernamePasswordAuthenticationToken((Object)name, authentication.getCredentials(), Collections.singletonList(new SimpleGrantedAuthority("ROLE_USER")));
    }
}

