/*
 * Decompiled with CFR 0.152.
 */
package authzserver;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SessionAttributes(value={"authorizationRequest"})
public class CustomApprovalEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CustomApprovalEndpoint.class);
    private final Environment environment;
    @Value(value="${confirmPage.appName}")
    private String appName;

    @Autowired
    public CustomApprovalEndpoint(Environment environment) {
        this.environment = environment;
    }

    @RequestMapping(value={"/oauth/confirm"})
    public ModelAndView getAccessConfirmation(Map<String, Object> model, HttpServletRequest request, PreAuthenticatedAuthenticationToken authentication) throws Exception {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)model.get("authorizationRequest");
        if (this.environment.acceptsProfiles(new String[]{"dev"}) && authorizationRequest == null) {
            this.development(model, request);
        }
        if (request.getAttribute("_csrf") != null) {
            model.put("_csrf", request.getAttribute("_csrf"));
        }
        model.put("appName", this.appName);
        return new ModelAndView("confirm", model);
    }

    private void development(Map<String, Object> model, HttpServletRequest request) {
        LOG.debug("Adding a mock authorization request to the model");
        model.put("authorizationRequest", new AuthorizationRequest("client_id", Collections.singletonList("groups")));
        LinkedHashMap<String, Boolean> scopes = new LinkedHashMap<String, Boolean>();
        scopes.put("scope.groups", false);
        request.setAttribute("scopes", scopes);
    }
}

