/*
 * Decompiled with CFR 0.152.
 */
package authzserver.shibboleth;

import authzserver.shibboleth.ShibbolethUser;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final String COLLAB_PERSON_ID_HEADER_NAME = "name-id";
    public static final String SCHAC_HOME_ORGANIZATION_HEADER_NAME = "schachomeorganization";
    public static final String SHIB_AUTHENTICATING_AUTHORITY = "Shib-Authenticating-Authority";
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
    private static final String EMPTY_HEADER_ERROR_TEMPLATE = "Header '%s' must be set";

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager) {
        this.setAuthenticationManager(authenticationManager);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String uid = request.getHeader(COLLAB_PERSON_ID_HEADER_NAME);
        if (StringUtils.isEmpty((Object)uid)) {
            throw new PreAuthenticatedCredentialsNotFoundException(String.format(EMPTY_HEADER_ERROR_TEMPLATE, COLLAB_PERSON_ID_HEADER_NAME));
        }
        String schacHomeOrganization = request.getHeader(SCHAC_HOME_ORGANIZATION_HEADER_NAME);
        if (StringUtils.isEmpty((Object)schacHomeOrganization)) {
            throw new PreAuthenticatedCredentialsNotFoundException(String.format(EMPTY_HEADER_ERROR_TEMPLATE, SCHAC_HOME_ORGANIZATION_HEADER_NAME));
        }
        String authenticatingAuthorities = request.getHeader(SHIB_AUTHENTICATING_AUTHORITY);
        if (StringUtils.isEmpty((Object)authenticatingAuthorities)) {
            throw new PreAuthenticatedCredentialsNotFoundException(String.format(EMPTY_HEADER_ERROR_TEMPLATE, SHIB_AUTHENTICATING_AUTHORITY));
        }
        String authenticatingAuthority = authenticatingAuthorities.split(";")[0];
        String email = request.getHeader("Shib-InetOrgPerson-mail");
        String displayName = request.getHeader("displayname");
        ShibbolethUser user = new ShibbolethUser(uid, schacHomeOrganization, displayName, authenticatingAuthority, email);
        LOG.debug("Assembled Shibboleth user from headers: {}", (Object)user);
        return user;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }
}

