/*
 * Decompiled with CFR 0.152.
 */
package authzserver.shibboleth;

import authzserver.shibboleth.ShibbolethUser;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.util.StringUtils;

public class ShibbolethPreAuthenticatedProcessingFilter
extends AbstractPreAuthenticatedProcessingFilter {
    public static final String SHIB_NAME_ID_HEADER_NAME = "name-id";
    public static final String SHIB_SCHAC_HOME_ORGANIZATION_HEADER_NAME = "schachomeorganization";
    public static final String SHIB_AUTHENTICATING_AUTHORITY = "Shib-Authenticating-Authority";
    public static final String SHIB_EMAIL = "Shib-InetOrgPerson-mail";
    public static final String SHIB_DISPLAY_NAME = "displayName";
    public static final String SHIB_EDU_PERSON_PRINCIPAL_NAME = "eduPersonPrincipalName";
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethPreAuthenticatedProcessingFilter.class);
    private static final String EMPTY_HEADER_ERROR_TEMPLATE = "Header '%s' must be set";

    public ShibbolethPreAuthenticatedProcessingFilter(AuthenticationManager authenticationManager) {
        this.setAuthenticationManager(authenticationManager);
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String uid = request.getHeader(SHIB_NAME_ID_HEADER_NAME);
        if (StringUtils.isEmpty((Object)uid)) {
            throw new PreAuthenticatedCredentialsNotFoundException(String.format(EMPTY_HEADER_ERROR_TEMPLATE, SHIB_NAME_ID_HEADER_NAME));
        }
        String schacHomeOrganization = request.getHeader(SHIB_SCHAC_HOME_ORGANIZATION_HEADER_NAME);
        if (StringUtils.isEmpty((Object)schacHomeOrganization)) {
            throw new PreAuthenticatedCredentialsNotFoundException(String.format(EMPTY_HEADER_ERROR_TEMPLATE, SHIB_SCHAC_HOME_ORGANIZATION_HEADER_NAME));
        }
        String authenticatingAuthorities = request.getHeader(SHIB_AUTHENTICATING_AUTHORITY);
        if (StringUtils.isEmpty((Object)authenticatingAuthorities)) {
            throw new PreAuthenticatedCredentialsNotFoundException(String.format(EMPTY_HEADER_ERROR_TEMPLATE, SHIB_AUTHENTICATING_AUTHORITY));
        }
        String authenticatingAuthority = authenticatingAuthorities.split(";")[0];
        String email = request.getHeader(SHIB_EMAIL);
        String displayName = request.getHeader(SHIB_DISPLAY_NAME);
        String eduPersonPrincipalName = request.getHeader(SHIB_EDU_PERSON_PRINCIPAL_NAME);
        ShibbolethUser user = new ShibbolethUser(uid, eduPersonPrincipalName, schacHomeOrganization, displayName, authenticatingAuthority, email);
        LOG.debug("Assembled Shibboleth user from headers: {}", (Object)user);
        return user;
    }

    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "N/A";
    }
}

