/*
 * Decompiled with CFR 0.152.
 */
package authzserver;

import authzserver.ConcurrentJdbcTokenStore;
import authzserver.CorsFilter;
import authzserver.SchacHomeAwareUserAuthenticationConverter;
import java.util.Locale;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.MetricFilterAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.TraceWebFilterAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2RequestFactory;
import org.springframework.security.oauth2.provider.approval.ApprovalStore;
import org.springframework.security.oauth2.provider.approval.ApprovalStoreUserApprovalHandler;
import org.springframework.security.oauth2.provider.approval.JdbcApprovalStore;
import org.springframework.security.oauth2.provider.approval.UserApprovalHandler;
import org.springframework.security.oauth2.provider.code.AuthorizationCodeServices;
import org.springframework.security.oauth2.provider.code.JdbcAuthorizationCodeServices;
import org.springframework.security.oauth2.provider.request.DefaultOAuth2RequestFactory;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.DefaultAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.UserAuthenticationConverter;
import org.springframework.security.oauth2.provider.token.store.JdbcTokenStore;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@SpringBootApplication(exclude={TraceWebFilterAutoConfiguration.class, MetricFilterAutoConfiguration.class})
public class AuthzServerApplication {
    public static final String ROLE_TOKEN_CHECKER = "ROLE_TOKEN_CHECKER";

    public static void main(String[] args) {
        SpringApplication.run(AuthzServerApplication.class, (String[])args);
    }

    @Bean
    public FilterRegistrationBean corsFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new CorsFilter());
        return filterRegistrationBean;
    }

    @Bean
    public LocaleResolver localeResolver() {
        CookieLocaleResolver slr = new CookieLocaleResolver();
        slr.setDefaultLocale(Locale.ENGLISH);
        return slr;
    }

    @Bean
    public LocaleChangeInterceptor localeChangeInterceptor() {
        LocaleChangeInterceptor lci = new LocaleChangeInterceptor();
        lci.setParamName("lang");
        return lci;
    }

    @Bean
    public WebMvcConfigurerAdapter adapter() {
        return new WebMvcConfigurerAdapter(){

            public void addInterceptors(InterceptorRegistry registry) {
                super.addInterceptors(registry);
                registry.addInterceptor((HandlerInterceptor)AuthzServerApplication.this.localeChangeInterceptor());
            }
        };
    }

    @Configuration
    @EnableAuthorizationServer
    protected static class Oauth2ServerConfig
    extends AuthorizationServerConfigurerAdapter {
        @Autowired
        private DataSource dataSource;
        @Autowired
        private ApprovalStoreUserApprovalHandler approvalStoreUserApprovalHandler;
        @Value(value="${oauthServer.accessTokenValiditySeconds}")
        private Integer accessTokenValiditySeconds;
        @Value(value="${oauthServer.refreshTokenValiditySeconds}")
        private Integer refreshTokenValiditySeconds;
        @Autowired
        private JdbcTokenStore tokenStore;
        @Autowired
        private PasswordEncoder passwordEncoder;

        protected Oauth2ServerConfig() {
        }

        public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
            DefaultAccessTokenConverter accessTokenConverter = new DefaultAccessTokenConverter();
            accessTokenConverter.setUserTokenConverter((UserAuthenticationConverter)new SchacHomeAwareUserAuthenticationConverter());
            endpoints.pathMapping("/oauth/confirm_access", "/oauth/confirm").userApprovalHandler((UserApprovalHandler)this.approvalStoreUserApprovalHandler).accessTokenConverter((AccessTokenConverter)accessTokenConverter).tokenServices((AuthorizationServerTokenServices)this.tokenServices()).authorizationCodeServices((AuthorizationCodeServices)new JdbcAuthorizationCodeServices(this.dataSource));
        }

        @Bean
        @Autowired
        public ApprovalStoreUserApprovalHandler approvalStoreUserApprovalHandler(@Value(value="${oauthServer.approvalExpirySeconds}") Integer approvalExpirySeconds, ApprovalStore approvalStore, ClientDetailsService clientDetailsService) {
            ApprovalStoreUserApprovalHandler userApprovalHandler = new ApprovalStoreUserApprovalHandler();
            userApprovalHandler.setApprovalExpiryInSeconds(approvalExpirySeconds.intValue());
            userApprovalHandler.setApprovalStore(approvalStore);
            userApprovalHandler.setClientDetailsService(clientDetailsService);
            DefaultOAuth2RequestFactory requestFactory = new DefaultOAuth2RequestFactory(clientDetailsService);
            userApprovalHandler.setRequestFactory((OAuth2RequestFactory)requestFactory);
            return userApprovalHandler;
        }

        @Bean
        public ApprovalStore approvalStore() {
            return new JdbcApprovalStore(this.dataSource);
        }

        @Bean
        public JdbcTokenStore tokenStore() {
            return new ConcurrentJdbcTokenStore(this.dataSource);
        }

        private DefaultTokenServices tokenServices() {
            DefaultTokenServices tokenServices = new DefaultTokenServices();
            tokenServices.setSupportRefreshToken(true);
            tokenServices.setTokenStore((TokenStore)this.tokenStore);
            tokenServices.setAccessTokenValiditySeconds(this.accessTokenValiditySeconds.intValue());
            tokenServices.setRefreshTokenValiditySeconds(this.refreshTokenValiditySeconds.intValue());
            return tokenServices;
        }

        public void configure(AuthorizationServerSecurityConfigurer oauthServer) {
            oauthServer.checkTokenAccess("hasAuthority('ROLE_TOKEN_CHECKER')").passwordEncoder(this.passwordEncoder);
        }

        @Bean
        public BCryptPasswordEncoder passwordEncoder() {
            return new BCryptPasswordEncoder();
        }

        public void configure(ClientDetailsServiceConfigurer configurer) throws Exception {
            configurer.jdbc(this.dataSource);
        }
    }
}

