/*
 * Decompiled with CFR 0.152.
 */
package authzserver;

import authzserver.shibboleth.ShibbolethUserDetailService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

@Controller
@SessionAttributes(value={"authorizationRequest"})
public class CustomApprovalEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CustomApprovalEndpoint.class);
    @Value(value="${confirmPage.logoUrl}")
    private String logoUrl;
    @Value(value="${confirmPage.appName}")
    private String appName;

    @RequestMapping(value={"/oauth/confirm"})
    public ModelAndView getAccessConfirmation(Map<String, Object> model, HttpServletRequest request, PreAuthenticatedAuthenticationToken authentication) throws Exception {
        ShibbolethUserDetailService.ShibbolethUser shibbolethUser = (ShibbolethUserDetailService.ShibbolethUser)authentication.getPrincipal();
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)model.get("authorizationRequest");
        LOG.debug("Displaying approval page for clientId {} to user {}", (Object)authorizationRequest.getClientId(), (Object)shibbolethUser.getUsername());
        if (request.getAttribute("_csrf") != null) {
            model.put("_csrf", request.getAttribute("_csrf"));
        }
        model.put("logoUrl", this.logoUrl);
        model.put("appName", this.appName);
        return new ModelAndView("confirm", model);
    }
}

