/*
 * Decompiled with CFR 0.152.
 */
package authzserver;

import authzserver.mock.MockShibbolethFilter;
import authzserver.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import authzserver.shibboleth.ShibbolethUserDetailService;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;

@Configuration
@EnableWebSecurity
public class ShibbolethSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ShibbolethSecurityConfig.class);

    @Bean
    @Profile(value={"dev"})
    public FilterRegistrationBean mockShibbolethFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new MockShibbolethFilter());
        filterRegistrationBean.addUrlPatterns(new String[]{"/oauth/authorize"});
        return filterRegistrationBean;
    }

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/static/**"})).antMatchers(new String[]{"/health"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.NEVER).and()).addFilterBefore((Filter)new ShibbolethPreAuthenticatedProcessingFilter(this.authenticationManagerBean()), AbstractPreAuthenticatedProcessingFilter.class).authorizeRequests().antMatchers(new String[]{"/oauth/authorize"})).hasAnyRole(new String[]{"USER"});
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        LOG.info("Configuring AuthenticationManager with a PreAuthenticatedAuthenticationProvider");
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService((AuthenticationUserDetailsService)new ShibbolethUserDetailService());
        auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
    }
}

