/*
 * Decompiled with CFR 0.152.
 */
package authzserver.shibboleth;

import authzserver.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class ShibbolethUserDetailService
implements AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> {
    public UserDetails loadUserDetails(PreAuthenticatedAuthenticationToken authentication) throws UsernameNotFoundException {
        ShibbolethPreAuthenticatedProcessingFilter.ShibbolethPrincipal shibbolethPrincipal = (ShibbolethPreAuthenticatedProcessingFilter.ShibbolethPrincipal)authentication.getPrincipal();
        return new ShibbolethUser(shibbolethPrincipal.username, shibbolethPrincipal.schacHomeOrganization, shibbolethPrincipal.displayName, shibbolethPrincipal.authenticatingAuthority, shibbolethPrincipal.email);
    }

    public static class ShibbolethUser
    implements UserDetails {
        private static final long serialVersionUID = 2L;
        private final String username;
        private final String schacHomeOrganization;
        private final String displayName;
        private final String authenticatingAuthority;
        private final String email;

        public String toString() {
            return "ShibbolethUser{username='" + this.username + '\'' + ", schacHomeOrganization='" + this.schacHomeOrganization + '\'' + ", displayName='" + this.displayName + '\'' + ", authenticatingAuthority='" + this.authenticatingAuthority + '\'' + ", email='" + this.email + '\'' + '}';
        }

        public ShibbolethUser(String username, String schacHomeOrganization, String displayName, String authenticatingAuthority, String email) {
            this.username = username;
            this.schacHomeOrganization = schacHomeOrganization;
            this.displayName = displayName;
            this.authenticatingAuthority = authenticatingAuthority;
            this.email = email;
        }

        public String getSchacHomeOrganization() {
            return this.schacHomeOrganization;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getAuthenticatingAuthority() {
            return this.authenticatingAuthority;
        }

        public String getEmail() {
            return this.email;
        }

        public Collection<? extends GrantedAuthority> getAuthorities() {
            return Collections.unmodifiableList(Arrays.asList(new SimpleGrantedAuthority("ROLE_USER")));
        }

        public String getPassword() {
            return null;
        }

        public String getUsername() {
            return this.username;
        }

        public boolean isAccountNonExpired() {
            return true;
        }

        public boolean isAccountNonLocked() {
            return true;
        }

        public boolean isCredentialsNonExpired() {
            return true;
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

