/*
 * Decompiled with CFR 0.152.
 */
package dashboard.manage;

import dashboard.domain.IdentityProvider;
import dashboard.domain.Provider;
import dashboard.domain.ServiceProvider;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.util.StreamUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class ClassPathResourceManage
implements Manage {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathResourceManage.class);
    private volatile Map<String, IdentityProvider> identityProviderMap = new HashMap();
    private volatile Map<String, ServiceProvider> serviceProviderMap = new HashMap();
    private volatile Map<String, ServiceProvider> exampleSingleTenants = new HashMap();

    public ClassPathResourceManage() {
        this.initializeMetadata();
    }

    public Optional<IdentityProvider> getIdentityProvider(String idpEntityId, boolean searchRevisions) {
        return Optional.ofNullable(this.identityProviderMap.get(idpEntityId));
    }

    public List<IdentityProvider> getInstituteIdentityProviders(String instituteId) {
        return this.identityProviderMap.values().stream().filter(identityProvider -> instituteId.equals(identityProvider.getInstitutionId())).collect(Collectors.toList());
    }

    public List<IdentityProvider> getAllIdentityProviders() {
        return new ArrayList<IdentityProvider>(this.identityProviderMap.values());
    }

    public List<IdentityProvider> getLinkedIdentityProviders(String spId) {
        if (this.exampleSingleTenants.containsKey(spId)) {
            return new ArrayList<IdentityProvider>();
        }
        ServiceProvider serviceProvider = (ServiceProvider)this.getServiceProvider(spId, EntityType.saml20_sp, false).orElseThrow(RuntimeException::new);
        if (serviceProvider.isAllowedAll()) {
            return this.identityProviderMap.values().stream().filter(identityProvider -> identityProvider.isAllowedAll() || identityProvider.getAllowedEntityIds().contains(spId)).collect(Collectors.toList());
        }
        return (List)serviceProvider.getAllowedEntityIds().stream().map(idpEntityId -> this.getIdentityProvider(idpEntityId, false)).collect(StreamUtils.filterEmpty());
    }

    public List<ServiceProvider> getLinkedServiceProviders(String idpId) {
        IdentityProvider identityProvider = (IdentityProvider)this.getIdentityProvider(idpId, false).orElseThrow(RuntimeException::new);
        if (identityProvider.isAllowedAll()) {
            return this.serviceProviderMap.values().stream().filter(serviceProvider -> serviceProvider.isAllowedAll() || serviceProvider.getAllowedEntityIds().contains(idpId)).collect(Collectors.toList());
        }
        return (List)identityProvider.getAllowedEntityIds().stream().map(spEntityId -> this.getServiceProvider(spEntityId, EntityType.saml20_sp, false)).collect(StreamUtils.filterEmpty());
    }

    public List<ServiceProvider> getByEntityIdin(List<String> entityIds) {
        return this.getAllServiceProviders().stream().filter(sp -> entityIds.contains(sp.getId())).collect(Collectors.toList());
    }

    public List<ServiceProvider> getAllServiceProviders() {
        Collection allSPs = new ArrayList(this.serviceProviderMap.values()).stream().filter(sp -> !sp.isHidden()).collect(Collectors.toList());
        allSPs.addAll(this.exampleSingleTenants.values());
        return new ArrayList<ServiceProvider>(allSPs);
    }

    public Optional<ServiceProvider> getServiceProvider(String spEntityId, EntityType type, boolean searchRevisions) {
        return type.equals((Object)EntityType.saml20_sp) || type.equals((Object)EntityType.oidc10_rp) ? Optional.ofNullable(this.serviceProviderMap.get(spEntityId)) : Optional.ofNullable(this.exampleSingleTenants.get(spEntityId));
    }

    public Optional<ServiceProvider> getServiceProviderById(Long spId, EntityType type) {
        return type.equals((Object)EntityType.saml20_sp) || type.equals((Object)EntityType.oidc10_rp) ? this.serviceProviderMap.values().stream().filter(sp -> sp.getEid().equals(spId)).findFirst() : this.exampleSingleTenants.values().stream().filter(sp -> sp.getEid().equals(spId)).findFirst();
    }

    public List<ServiceProvider> getInstitutionalServicesForIdp(String instituteId) {
        return StringUtils.hasText((String)instituteId) ? this.serviceProviderMap.values().stream().filter(sp -> instituteId.equals(sp.getInstitutionId())).collect(Collectors.toList()) : Collections.emptyList();
    }

    private void initializeMetadata() {
        try {
            this.identityProviderMap = this.parseProviders(this.getIdpResource(), arg_0 -> ((ClassPathResourceManage)this).identityProvider(arg_0));
            this.serviceProviderMap = this.parseProviders(this.getSpResource(), sp -> this.serviceProvider(sp, EntityType.saml20_sp));
            Map relyingPartiesMap = this.parseProviders(this.getRpResource(), rp -> this.serviceProvider(rp, EntityType.oidc10_rp));
            this.serviceProviderMap.putAll(relyingPartiesMap);
            long maxEid = this.serviceProviderMap.values().stream().max(Comparator.comparing(Provider::getEid)).get().getEid() + 1L;
            this.exampleSingleTenants = this.parseProviders(this.getSingleTenantResource(), sp -> this.serviceProvider(sp, EntityType.single_tenant_template));
            this.exampleSingleTenants.values().forEach(singleTenant -> singleTenant.setEid(Long.valueOf(singleTenant.getEid() + maxEid)));
            LOG.debug("Initialized Manage Resources. Number of IDPs {}. Number of SPs {}", (Object)this.identityProviderMap.size(), (Object)this.serviceProviderMap.size());
        }
        catch (Throwable e) {
            LOG.error("Error in refreshing / initializing metadata", e);
        }
    }

    private Resource getIdpResource() {
        return new ClassPathResource("manage/identity-providers.json");
    }

    private Resource getSpResource() {
        return new ClassPathResource("manage/service-providers.json");
    }

    private Resource getRpResource() {
        return new ClassPathResource("manage/relying-parties.json");
    }

    private Resource getSingleTenantResource() {
        return new ClassPathResource("manage/single-tenants.json");
    }
}

