/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import dashboard.manage.ClassPathResourceManage;
import dashboard.manage.Manage;
import dashboard.manage.UrlResourceManage;
import dashboard.pdp.PdpService;
import dashboard.pdp.PdpServiceImpl;
import dashboard.pdp.PdpServiceMock;
import dashboard.sab.HttpClientTransport;
import dashboard.sab.Sab;
import dashboard.sab.SabClient;
import dashboard.sab.SabClientMock;
import dashboard.sab.SabTransport;
import dashboard.service.Services;
import dashboard.service.impl.JiraClient;
import dashboard.service.impl.JiraClientImpl;
import dashboard.service.impl.JiraClientMock;
import dashboard.service.impl.ServicesImpl;
import dashboard.stats.Stats;
import dashboard.stats.StatsImpl;
import dashboard.stats.StatsMock;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.MetricFilterAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.TraceRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.TraceWebFilterAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(exclude={SecurityAutoConfiguration.class, FreeMarkerAutoConfiguration.class, TraceWebFilterAutoConfiguration.class, TraceRepositoryAutoConfiguration.class, MetricFilterAutoConfiguration.class})
public class Application {
    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public Services services(Manage manage, @Value(value="${guestidp.entityid}") String guestIdp) {
        return new ServicesImpl(manage, guestIdp);
    }

    @Bean
    public Sab sab(HttpClientTransport httpClientTransport, @Value(value="${dashboard.feature.sab}") boolean sabEnabled) {
        return sabEnabled ? new SabClient((SabTransport)httpClientTransport) : new SabClientMock();
    }

    @Bean
    public Manage manage(@Value(value="${dashboard.feature.manage}") boolean manageEnabled, @Value(value="${manage.username}") String username, @Value(value="${manage.password}") String password, @Value(value="${manage.manageBaseUrl}") String manageBaseUrl) {
        return manageEnabled ? new UrlResourceManage(username, password, manageBaseUrl) : new ClassPathResourceManage();
    }

    @Bean
    @Autowired
    public Stats stats(@Value(value="${dashboard.feature.statistics}") boolean statsEnabled, @Value(value="${statsUser}") String user, @Value(value="${statsPassword}") String password, @Value(value="${statsBaseUrl}") String baseUrl, Manage manage) {
        return statsEnabled ? new StatsImpl(user, password, baseUrl) : new StatsMock(manage);
    }

    @Bean
    public JiraClient jiraClient(@Value(value="${dashboard.feature.jira}") boolean jiraEnabled, @Value(value="${jiraBaseUrl}") String baseUrl, @Value(value="${jiraUsername}") String username, @Value(value="${jiraPassword}") String password, @Value(value="${jiraProjectKey}") String projectKey, @Value(value="${jiraDueDateWeeks}") int dueDateWeeks) throws IOException {
        return jiraEnabled ? new JiraClientImpl(baseUrl, username, password, projectKey, dueDateWeeks) : new JiraClientMock("https://idp.surfnet.nl");
    }

    @Bean
    public PdpService pdpService(@Value(value="${dashboard.feature.pdp}") boolean pdpEnabled, @Value(value="${pdp.server}") String server, @Value(value="${pdp.username}") String username, @Value(value="${pdp.password}") String password) {
        return pdpEnabled ? new PdpServiceImpl(server, username, password) : new PdpServiceMock();
    }
}

