/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import com.google.common.base.Strings;
import dashboard.control.BaseController;
import dashboard.control.RestResponse;
import dashboard.domain.Action;
import dashboard.domain.Category;
import dashboard.domain.CategoryValue;
import dashboard.domain.CoinUser;
import dashboard.domain.InstitutionIdentityProvider;
import dashboard.domain.Provider;
import dashboard.domain.Service;
import dashboard.domain.ServiceProvider;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.service.ActionsService;
import dashboard.service.Services;
import dashboard.util.SpringSecurity;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/dashboard/api/services"}, produces={"application/json"})
public class ServicesController
extends BaseController {
    @Autowired
    private Services services;
    @Autowired
    private Manage manage;
    @Autowired
    private ActionsService actionsService;

    @RequestMapping
    public RestResponse<Map<String, Object>> index(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale) throws IOException {
        List servicesForIdp = this.services.getServicesForIdp(idpEntityId, locale);
        List categories = this.getCategories(servicesForIdp);
        HashMap<String, List> result = new HashMap<String, List>();
        result.put("apps", servicesForIdp);
        result.put("facets", categories);
        return this.createRestResponse(result);
    }

    private List<Category> getCategories(List<Service> servicesForIdp) {
        Map<String, List<Category>> groupedCategories = servicesForIdp.stream().map(s -> s.getCategories()).flatMap(Collection::stream).collect(Collectors.groupingBy(Category::getName));
        return groupedCategories.entrySet().stream().map(entry -> {
            List categoryValues = ((List)entry.getValue()).stream().map(cat -> cat.getValues().stream().map(CategoryValue::getValue)).flatMap(Function.identity()).collect(Collectors.toSet()).stream().map(CategoryValue::new).collect(Collectors.toList());
            return new Category((String)entry.getKey(), "type_of_service", categoryValues);
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/connected"})
    public RestResponse<List<Service>> connected(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale) throws IOException {
        return this.createRestResponse(this.services.getServicesForIdp(idpEntityId, locale).stream().filter(Service::isConnected).collect(Collectors.toList()));
    }

    @PostMapping(value={"/by-entity-ids"})
    public RestResponse<List<Service>> byEnntityIds(@RequestBody List<String> entityIds, Locale locale) throws IOException {
        return this.createRestResponse((Object)this.services.getServicesByEntityIds(entityIds, locale));
    }

    @RequestMapping(value={"/idps"})
    public RestResponse<List<InstitutionIdentityProvider>> getConnectedIdps(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam String spEntityId, @RequestParam String type) {
        ServiceProvider serviceProvider = (ServiceProvider)this.manage.getServiceProvider(spEntityId, EntityType.valueOf((String)type), false).orElseThrow(IllegalArgumentException::new);
        List idps = serviceProvider.isAllowedAll() ? this.manage.getLinkedIdentityProviders(spEntityId).stream().map(idp -> new InstitutionIdentityProvider(idp.getId(), idp.getName(Provider.Language.EN), idp.getName(Provider.Language.NL), idp.getInstitutionId(), idp.getState())).collect(Collectors.toList()) : serviceProvider.getAllowedEntityIds().stream().map(entityId -> this.manage.getIdentityProvider(entityId, false)).filter(Optional::isPresent).map(Optional::get).map(idp -> new InstitutionIdentityProvider(idp.getId(), idp.getName(Provider.Language.EN), idp.getName(Provider.Language.NL), idp.getInstitutionId(), idp.getState())).collect(Collectors.toList());
        return this.createRestResponse(idps);
    }

    @PostMapping(value={"/download"})
    public List<String[]> download(@RequestBody Map<String, Object> body, Locale locale, HttpServletResponse response) throws IOException {
        String idpEntityId = (String)body.get("idp");
        List ids = (List)body.get("ids");
        List services = this.services.getServicesForIdp(idpEntityId, locale);
        Stream<String[]> values = ids.stream().map(id -> this.getServiceById(services, Long.valueOf(id.longValue()))).flatMap(opt -> opt.map(Stream::of).orElse(Stream.empty())).map(service -> new String[]{String.valueOf(service.getId()), this.stripBreakingWhitespace(service.getName()), service.getSpEntityId(), this.stripBreakingWhitespace(service.getDescription()), service.getAppUrl(), service.getWikiUrl(), service.getSupportMail(), String.valueOf(service.isConnected()), service.getLicenseStatus().name(), String.valueOf(service.isPublishedInEdugain()), String.valueOf(service.isExampleSingleTenant()), String.valueOf(service.isStrongAuthentication()), String.valueOf(!service.getArp().isNoArp()), service.getArp().getAttributes().keySet().stream().collect(Collectors.joining(" - "))});
        Stream<String[]> headers = Stream.of(new String[]{"id", "name", "entityID", "description", "app-url", "wiki-url", "support-mail", "connected", "licenseStatus", "publishedInEdugain", "singleTenant", "strongAuthentication", "arpEnabled", "arpAttributes"});
        List<String[]> rows = Stream.concat(headers, values).collect(Collectors.toList());
        return rows;
    }

    private String stripBreakingWhitespace(String input) {
        return StringUtils.hasText((String)input) ? input.trim().replaceAll("[\n,]", "") : "";
    }

    private Optional<Service> getServiceById(List<Service> services, Long id) {
        return services.stream().filter(service -> service.getId() == id.longValue()).findFirst();
    }

    @RequestMapping(value={"/detail"})
    public ResponseEntity<RestResponse<Service>> get(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam Long spId, @RequestParam String entityType, Locale locale) throws IOException {
        Optional serviceByEntityId = this.services.getServiceById(idpEntityId, spId, EntityType.valueOf((String)entityType), locale);
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        boolean eraseMails = currentUser.isGuest() || currentUser.isDashboardMember();
        return serviceByEntityId.map(service -> eraseMails ? ServicesController.eraseMailsFromService((Service)service) : service).map(service -> ResponseEntity.ok((Object)this.createRestResponse(service))).orElse(new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    public static Service eraseMailsFromService(Service service) {
        service.setSupportMail(null);
        service.setContactPersons(Collections.emptyList());
        service.setManipulationNotes(null);
        return service;
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/connect"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Action>> connect(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam(value="comments", required=false) String comments, @RequestParam(value="spEntityId") String spEntityId, @RequestParam(value="type") String type, Locale locale) throws IOException {
        return this.createAction(idpEntityId, comments, spEntityId, type, Action.Type.LINKREQUEST, locale).map(action -> ResponseEntity.ok((Object)this.createRestResponse(action))).orElse(new ResponseEntity(HttpStatus.FORBIDDEN));
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/disconnect"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Action>> disconnect(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestParam(value="comments", required=false) String comments, @RequestParam(value="spEntityId") String spEntityId, @RequestParam(value="type") String type, Locale locale) throws IOException {
        return this.createAction(idpEntityId, comments, spEntityId, type, Action.Type.UNLINKREQUEST, locale).map(action -> ResponseEntity.ok((Object)this.createRestResponse(action))).orElse(new ResponseEntity(HttpStatus.FORBIDDEN));
    }

    private Optional<Action> createAction(String idpEntityId, String comments, String entityId, String typeMetaData, Action.Type jiraType, Locale locale) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin() && currentUser.isDashboardViewer()) {
            return Optional.empty();
        }
        if (Strings.isNullOrEmpty((String)currentUser.getIdp().getInstitutionId())) {
            return Optional.empty();
        }
        List services = this.services.getServicesForIdp(idpEntityId, locale);
        Optional<Service> optional = services.stream().filter(s -> s.getSpEntityId().equals(entityId)).findFirst();
        if (optional.isPresent()) {
            Service service = optional.get();
            Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).body(comments).idpId(idpEntityId).spId(entityId).typeMetaData(typeMetaData).service(service).type(jiraType).build();
            return Optional.of(this.actionsService.create(action, Collections.emptyList()));
        }
        return Optional.empty();
    }
}

