/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import com.google.common.base.Strings;
import dashboard.control.BaseController;
import dashboard.control.RestResponse;
import dashboard.control.ServicesController;
import dashboard.domain.Action;
import dashboard.domain.Change;
import dashboard.domain.CoinAuthority;
import dashboard.domain.CoinUser;
import dashboard.domain.Consent;
import dashboard.domain.ConsentType;
import dashboard.domain.ContactPerson;
import dashboard.domain.IdentityProvider;
import dashboard.domain.InviteRequest;
import dashboard.domain.JiraFilter;
import dashboard.domain.LoaLevelChange;
import dashboard.domain.Provider;
import dashboard.domain.ResendInviteRequest;
import dashboard.domain.Service;
import dashboard.domain.ServiceProvider;
import dashboard.domain.Settings;
import dashboard.domain.UpdateInviteRequest;
import dashboard.mail.MailBox;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.service.ActionsService;
import dashboard.service.Services;
import dashboard.util.SpringSecurity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard/api/users"}, produces={"application/json"})
public class UsersController
extends BaseController {
    @Autowired
    private Manage manage;
    @Autowired
    private Services services;
    @Autowired
    private ActionsService actionsService;
    @Autowired
    private MailBox mailbox;
    private static final Logger LOG = LoggerFactory.getLogger(UsersController.class);

    @RequestMapping(value={"/me"})
    public RestResponse<CoinUser> me() {
        return this.createRestResponse((Object)SpringSecurity.getCurrentUser());
    }

    @PreAuthorize(value="hasRole('DASHBOARD_SUPER_USER')")
    @PostMapping(value={"/inviteRequest"})
    public ResponseEntity<RestResponse<Object>> inviteRequest(@RequestBody InviteRequest inviteRequest) throws IOException, MessagingException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        String spEntityId = inviteRequest.getSpEntityId();
        String emails = inviteRequest.getContactPersons().stream().map(cp -> cp.getName() + "<" + cp.getEmailAddress() + ">").collect(Collectors.joining(", "));
        String emailTo = inviteRequest.getContactPersons().stream().map(cp -> cp.getEmailAddress()).collect(Collectors.joining(", "));
        String body = "Invite request initiated by dashboard super user. Mails sent to: " + emails + ".";
        if (inviteRequest.isContainsMessage()) {
            body = body + " The invitation message from the SURFconext super user:\n" + inviteRequest.getMessage();
        }
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).body(body).emailTo(emailTo).typeMetaData(inviteRequest.getTypeMetaData()).idpId(inviteRequest.getIdpEntityId()).spId(spEntityId).type(Action.Type.LINKINVITE).build();
        action = this.actionsService.create(action, Collections.emptyList());
        this.mailbox.sendInviteMail(inviteRequest, action);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_SUPER_USER')")
    @PutMapping(value={"/inviteRequest"})
    public ResponseEntity<RestResponse<Object>> updateInviteRequest(@RequestBody UpdateInviteRequest updateInviteRequest) throws IOException, MessagingException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        String commentWithUser = String.format("%s / %s has %s this Invite request.", currentUser.getUid(), currentUser.getFriendlyName(), updateInviteRequest.getStatus().name().toLowerCase());
        String comment = updateInviteRequest.getComment();
        if (StringUtils.hasText((String)comment)) {
            commentWithUser = commentWithUser.concat(" User comment: ").concat(comment);
        }
        if (UpdateInviteRequest.Status.ACCEPTED.equals((Object)updateInviteRequest.getStatus())) {
            this.actionsService.approveInviteRequest(updateInviteRequest.getJiraKey(), commentWithUser);
        } else {
            this.actionsService.rejectInviteRequest(updateInviteRequest.getJiraKey(), commentWithUser);
        }
        return ResponseEntity.ok((Object)this.createRestResponse((Object)updateInviteRequest));
    }

    @PreAuthorize(value="hasRole('DASHBOARD_SUPER_USER')")
    @PostMapping(value={"/resendInviteRequest"})
    public ResponseEntity<RestResponse<Object>> resendInviteRequest(@RequestBody ResendInviteRequest resendInviteRequest) throws IOException, MessagingException {
        JiraFilter jiraFilter = new JiraFilter();
        jiraFilter.setKey(resendInviteRequest.getJiraKey());
        Action action = (Action)this.actionsService.searchTasks(resendInviteRequest.getIdpId(), jiraFilter).getIssues().stream().findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Jira issue with key %s for IdP %s not found.", resendInviteRequest.getJiraKey(), resendInviteRequest.getIdpId())));
        String emailTo = action.getEmailTo();
        if (StringUtils.isEmpty((Object)emailTo)) {
            throw new IllegalArgumentException(String.format("There are no emails set on issue %s", resendInviteRequest.getJiraKey()));
        }
        this.mailbox.sendInviteMailReminder(action);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)resendInviteRequest));
    }

    @RequestMapping(value={"/disableConsent"})
    public List<Consent> disableConsent() {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isGuest()) {
            return Collections.emptyList();
        }
        String id = currentUser.getIdp().getId();
        return ((IdentityProvider)this.manage.getIdentityProvider(id, false).orElseThrow(() -> new IllegalArgumentException(String.format("IdP %s not found", id)))).getDisableConsent();
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/super/idps"})
    public ResponseEntity<RestResponse<Map<String, List<?>>>> idps() {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (!currentUser.isSuperUser()) {
            LOG.warn("IdP's endpoint is only allowed for superUser, not for {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        List idps = this.manage.getAllIdentityProviders().stream().sorted(Comparator.comparing(Provider::getName)).collect(Collectors.toList());
        List<String> roles = Arrays.asList(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER.name(), CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN.name());
        HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
        payload.put("idps", idps);
        payload.put("roles", roles);
        return new ResponseEntity((Object)this.createRestResponse(payload), HttpStatus.OK);
    }

    @RequestMapping(value={"/me/serviceproviders"}, method={RequestMethod.GET})
    public RestResponse<List<Service>> serviceProviders(Locale locale) throws IOException {
        boolean eraseMails;
        List usersServices = this.getServiceProvidersForCurrentUser(locale);
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        IdentityProvider idp = currentUser.getIdp();
        boolean bl = eraseMails = currentUser.isGuest() || currentUser.isDashboardMember() && !idp.isDisplayAdminEmailsInDashboard();
        if (eraseMails) {
            usersServices = usersServices.stream().map(service -> ServicesController.eraseMailsFromService((Service)service)).collect(Collectors.toList());
        }
        return this.createRestResponse((Object)usersServices);
    }

    private List<Service> getServiceProvidersForCurrentUser(Locale locale) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        Optional switchedToIdp = currentUser.getSwitchedToIdp();
        String usersInstitutionId = switchedToIdp.isPresent() ? ((IdentityProvider)switchedToIdp.get()).getInstitutionId() : currentUser.getInstitutionId();
        return Strings.isNullOrEmpty((String)usersInstitutionId) ? Collections.emptyList() : this.services.getInstitutionalServicesForIdp(usersInstitutionId, locale);
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/me/switch-to-idp"})
    public ResponseEntity<Void> currentIdp(@RequestParam(value="idpId", required=false) String switchToIdp, @RequestParam(value="role", required=false) String role, HttpServletResponse response) {
        if (Strings.isNullOrEmpty((String)switchToIdp)) {
            SpringSecurity.clearSwitchedIdp();
        } else {
            IdentityProvider identityProvider = (IdentityProvider)this.manage.getIdentityProvider(switchToIdp, false).orElseThrow(() -> new SecurityException(switchToIdp + " does not exist"));
            SpringSecurity.setSwitchedToIdp((IdentityProvider)identityProvider, (String)role);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/me/consent"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Object>> updateConsentSettings(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestBody Consent consent) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin() && currentUser.isDashboardViewer()) {
            LOG.warn("Consent endpoint is not allowed for superUser / dashboardViewer, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        IdentityProvider idp = currentUser.getIdp();
        Optional<Consent> previousConsent = idp.getDisableConsent().stream().filter(c -> c.getSpEntityId().equals(consent.getSpEntityId())).findAny();
        String idIdp = idp.getId();
        List changes = this.getChanges(idIdp, previousConsent, consent);
        if (changes.isEmpty()) {
            return ResponseEntity.ok((Object)this.createRestResponse(Collections.singletonMap("no-changes", true)));
        }
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).idpId(idpEntityId).spId(consent.getSpEntityId()).consent(consent).type(Action.Type.CHANGE).build();
        action = this.actionsService.create(action, changes);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/me/surfsecureid"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Object>> updateSurfSecureId(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestBody LoaLevelChange loaLevelChange) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin()) {
            LOG.warn("SURF secure ID endpoint is not allowed for superUser / dashboardViewer, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        Optional serviceProviderOptional = this.manage.getServiceProvider(loaLevelChange.getEntityId(), EntityType.valueOf((String)loaLevelChange.getEntityType()), false);
        ServiceProvider serviceProvider = (ServiceProvider)serviceProviderOptional.orElseThrow(IllegalArgumentException::new);
        String minimalLoaLevel = serviceProvider.getMinimalLoaLevel();
        IdentityProvider idp = currentUser.getIdp();
        List changes = this.getChanges(idp.getId(), minimalLoaLevel, loaLevelChange.getLoaLevel());
        if (changes.isEmpty()) {
            return ResponseEntity.ok((Object)this.createRestResponse(Collections.singletonMap("no-changes", true)));
        }
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).idpId(idpEntityId).spId(loaLevelChange.getEntityId()).loaLevel(loaLevelChange.getLoaLevel()).type(Action.Type.CHANGE).build();
        action = this.actionsService.create(action, changes);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/me/settings"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Object>> updateSettings(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale, @RequestBody Settings settings) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin() && currentUser.isDashboardViewer()) {
            LOG.warn("Settings endpoint is not allowed for superUser / dashboardViewer, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        IdentityProvider idp = currentUser.getSwitchedToIdp().orElse(currentUser.getIdp());
        List changes = this.getChanges(locale, settings, idp);
        if (changes.isEmpty()) {
            return ResponseEntity.ok((Object)this.createRestResponse(Collections.singletonMap("no-changes", true)));
        }
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).idpId(idpEntityId).settings(settings).type(Action.Type.CHANGE).build();
        action = this.actionsService.create(action, changes);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    protected List<Change> getChanges(String idpId, Optional<Consent> previousConsentOptional, Consent consent) throws IOException {
        ArrayList<Change> changes = new ArrayList<Change>();
        if (!previousConsentOptional.isPresent() && consent.getType().equals((Object)ConsentType.DEFAULT_CONSENT) && StringUtils.isEmpty((Object)consent.getExplanationEn()) && StringUtils.isEmpty((Object)consent.getExplanationEn())) {
            return changes;
        }
        Consent previousConsent = previousConsentOptional.orElse(new Consent());
        this.diff(changes, idpId, (Object)previousConsent.getSpEntityId(), (Object)consent.getSpEntityId(), "consent:sp:name");
        this.diff(changes, idpId, (Object)previousConsent.getExplanationEn(), (Object)consent.getExplanationEn(), "consent:explanation:en");
        this.diff(changes, idpId, (Object)previousConsent.getExplanationNl(), (Object)consent.getExplanationNl(), "consent:explanation:nl");
        this.diff(changes, idpId, (Object)previousConsent.getType(), (Object)consent.getType(), "consent:type");
        return changes;
    }

    protected List<Change> getChanges(String idpId, String previousMinimalLoaLevel, String newMinimalLoaLevel) throws IOException {
        ArrayList<Change> changes = new ArrayList<Change>();
        if (StringUtils.hasText((String)previousMinimalLoaLevel) && previousMinimalLoaLevel.equals(newMinimalLoaLevel)) {
            return changes;
        }
        this.diff(changes, idpId, (Object)previousMinimalLoaLevel, (Object)newMinimalLoaLevel, "coin:stepup:requireloa");
        return changes;
    }

    protected List<Change> getChanges(Locale locale, Settings settings, IdentityProvider idp) throws IOException {
        ArrayList<Change> changes = new ArrayList<Change>();
        String idpId = idp.getId();
        this.diff(changes, idpId, idp.getKeywords().get("en"), (Object)settings.getKeywordsEn(), "keywords:en");
        this.diff(changes, idpId, idp.getKeywords().get("nl"), (Object)settings.getKeywordsNl(), "keywords:nl");
        this.diff(changes, idpId, idp.getHomeUrls().get("en"), (Object)settings.getOrganisationUrlEn(), "organisationURL:en");
        this.diff(changes, idpId, idp.getHomeUrls().get("nl"), (Object)settings.getOrganisationUrlNl(), "organisationURL:nl");
        this.diff(changes, idpId, idp.getOrganisationDisplayNames().get("en"), (Object)settings.getOrganisationDisplayNameEn(), "organisationDisplayName:en");
        this.diff(changes, idpId, idp.getOrganisationDisplayNames().get("nl"), (Object)settings.getOrganisationDisplayNameNl(), "organisationDisplayName:nl");
        this.diff(changes, idpId, idp.getOrganisationNames().get("en"), (Object)settings.getOrganisationNameEn(), "organisationName:en");
        this.diff(changes, idpId, idp.getOrganisationNames().get("nl"), (Object)settings.getOrganisationNameNl(), "organisationName:nl");
        this.diff(changes, idpId, idp.getDescriptions().get("en"), (Object)settings.getDescriptionsEn(), "description:en");
        this.diff(changes, idpId, idp.getDescriptions().get("nl"), (Object)settings.getDescriptionsNl(), "description:nl");
        this.diff(changes, idpId, idp.getDisplayNames().get("en"), (Object)settings.getDisplayNamesEn(), "displayName:en");
        this.diff(changes, idpId, idp.getDisplayNames().get("nl"), (Object)settings.getDisplayNamesNl(), "displayName:nl");
        this.diff(changes, idpId, (Object)idp.isPublishedInEdugain(), (Object)settings.isPublishedInEdugain(), "coin:publish_in_edugain");
        this.diff(changes, idpId, (Object)idp.isConnectToRSServicesAutomatically(), (Object)settings.isConnectToRSServicesAutomatically(), "coin:entity_categories:1 - http://refeds.org/category/research-and-scholarship");
        this.diff(changes, idpId, (Object)idp.isAllowMaintainersToManageAuthzRules(), (Object)settings.isAllowMaintainersToManageAuthzRules(), "coin:allow_maintainers_to_manage_authz_rules");
        this.diff(changes, idpId, (Object)idp.isDisplayAdminEmailsInDashboard(), (Object)settings.isDisplayAdminEmailsInDashboard(), "coin:display_admin_emails_in_dashboard");
        this.diff(changes, idpId, (Object)idp.isDisplayStatsInDashboard(), (Object)settings.isDisplayStatsInDashboard(), "coin:display_stats_in_dashboard");
        this.diff(changes, idpId, (Object)idp.getLogoUrl(), (Object)settings.getLogoUrl(), "logo:0:url");
        this.diff(changes, idpId, (Object)idp.getState(), (Object)(settings.getStateType() != null ? settings.getStateType().name() : null), "state");
        this.diffContactPersons(changes, idpId, idp.getContactPersons(), settings.getContactPersons());
        List serviceProviders = this.getServiceProvidersForCurrentUser(locale);
        settings.getServiceProviderSettings().forEach(sp -> {
            Optional<Service> first = serviceProviders.stream().filter(service -> service.getSpEntityId().equals(sp.getSpEntityId())).findFirst();
            first.ifPresent(service -> {
                String id = service.getSpEntityId();
                this.diff(changes, id, service.getDescriptions().get("en"), (Object)sp.getDescriptionEn(), "description:en");
                this.diff(changes, id, service.getDescriptions().get("nl"), (Object)sp.getDescriptionNl(), "description:nl");
                this.diff(changes, id, service.getDisplayNames().get("en"), (Object)sp.getDisplayNameEn(), "displayName:en");
                this.diff(changes, id, service.getDisplayNames().get("nl"), (Object)sp.getDisplayNameNl(), "displayName:nl");
                this.diff(changes, id, (Object)service.isPublishedInEdugain(), (Object)sp.isPublishedInEdugain(), "coin:publish_in_edugain");
                this.diff(changes, id, (Object)service.isGuestEnabled(), (Object)sp.isHasGuestEnabled(), "Guest Login Enabled");
                this.diff(changes, id, (Object)service.isNoConsentRequired(), (Object)sp.isNoConsentRequired(), "coin:no_consent_required");
                this.diff(changes, idpId, (Object)service.getState(), (Object)(sp.getStateType() != null ? sp.getStateType().name() : null), "state");
                this.diffContactPersons(changes, id, service.getContactPersons(), sp.getContactPersons());
            });
        });
        return changes;
    }

    private void diffContactPersons(List<Change> changes, String id, List<ContactPerson> contactPersons, List<ContactPerson> newContactPersons) {
        if (CollectionUtils.isEmpty(contactPersons) && CollectionUtils.isEmpty(newContactPersons)) {
            return;
        }
        for (int i = 0; i < contactPersons.size(); ++i) {
            ContactPerson contactPerson = contactPersons.get(i);
            if (newContactPersons == null || newContactPersons.size() < i + 1) continue;
            ContactPerson newContactPerson = newContactPersons.get(i);
            this.diff(changes, id, (Object)contactPerson.getName(), (Object)newContactPerson.getName(), "contacts:" + i + ":name");
            this.diff(changes, id, (Object)contactPerson.getEmailAddress(), (Object)newContactPerson.getEmailAddress(), "contacts:" + i + ":emailAddress");
            this.diff(changes, id, (Object)contactPerson.getTelephoneNumber(), (Object)newContactPerson.getTelephoneNumber(), "contacts:" + i + ":telephoneNumber");
            this.diff(changes, id, (Object)contactPerson.getContactPersonType(), (Object)newContactPerson.getContactPersonType(), "contacts:" + i + ":contactType");
        }
    }

    private void diff(List<Change> changes, String id, Object oldValue, Object newValue, String attributeName) {
        if (this.changed(oldValue, newValue)) {
            changes.add(new Change(id, attributeName, String.format("%s", oldValue), String.format("%s", newValue)));
        }
    }

    private boolean changed(Object oldValue, Object newValue) {
        boolean newNotNull;
        boolean oldNotNull;
        boolean bl = oldValue instanceof String ? StringUtils.hasText((String)((String)oldValue)) : (oldNotNull = oldValue != null);
        boolean bl2 = newValue instanceof String ? StringUtils.hasText((String)((String)newValue)) : (newNotNull = newValue != null);
        if (!oldNotNull && !newNotNull) {
            return false;
        }
        if (oldNotNull && !newNotNull) {
            return true;
        }
        if (!oldNotNull && newNotNull) {
            return true;
        }
        return !oldValue.equals(newValue);
    }
}

