/*
 * Decompiled with CFR 0.152.
 */
package dashboard.mail;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.MustacheFactory;
import dashboard.domain.Action;
import dashboard.domain.ContactPerson;
import dashboard.domain.InviteRequest;
import dashboard.manage.EntityType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HtmlUtils;

public class MailBox {
    private JavaMailSender mailSender;
    private String emailFrom;
    private List<String> administrativeEmails;
    private String mailBaseUrl;
    private final MustacheFactory mustacheFactory = new DefaultMustacheFactory();

    public MailBox(JavaMailSender mailSender, String emailFrom, String administrativeEmails, String mailBaseUrl) {
        this.administrativeEmails = Arrays.asList(administrativeEmails.split(","));
        this.emailFrom = emailFrom;
        this.mailSender = mailSender;
        this.mailBaseUrl = mailBaseUrl;
    }

    public void sendInviteMail(InviteRequest inviteRequest, Action action) {
        String jiraKey = (String)action.getJiraKey().orElseThrow(() -> new IllegalArgumentException("No jirKey in the ticket"));
        List to = inviteRequest.getContactPersons().stream().filter(ContactPerson::isSabContact).map(ContactPerson::getEmailAddress).collect(Collectors.toList());
        List cc = inviteRequest.getContactPersons().stream().filter(cp -> !cp.isSabContact()).map(ContactPerson::getEmailAddress).collect(Collectors.toList());
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("title", "Uitnodiging voor een nieuwe SURFconext koppeling");
        variables.put("inviteRequest", (String)inviteRequest);
        variables.put("action", (String)action);
        variables.put("mailBaseUrl", this.mailBaseUrl);
        variables.put("salutation", inviteRequest.getContactPersons().stream().filter(ContactPerson::isSabContact).map(cp -> cp.getName()).collect(Collectors.joining(", ")));
        variables.put("metaDataType", StringUtils.isEmpty((Object)action.getTypeMetaData()) ? EntityType.saml20_sp.name() : action.getTypeMetaData());
        String html = this.mailTemplate("invite_request_nl.html", variables);
        String subject = String.format("Uitnodiging voor een nieuwe SURFconext koppeling met %s (ticket %s)", inviteRequest.getSpName(), jiraKey);
        try {
            this.sendMail(html, subject, to, cc, true, this.emailFrom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendAdministrativeMail(String body, String subject) throws MessagingException, IOException {
        this.sendMail(body, subject, this.administrativeEmails, Collections.emptyList(), false, this.emailFrom);
    }

    private void sendMail(String html, String subject, List<String> to, List<String> cc, boolean inHtml, String emailFrom) throws MessagingException, IOException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, false);
        helper.setSubject(subject);
        helper.setTo(to.toArray(new String[0]));
        helper.setCc(cc.toArray(new String[0]));
        this.setText(html, helper, inHtml);
        helper.setFrom(emailFrom);
        this.doSendMail(message);
    }

    protected void setText(String html, MimeMessageHelper helper, boolean isHtml) throws MessagingException, IOException {
        helper.setText(html, isHtml);
    }

    protected void doSendMail(MimeMessage message) {
        new Thread(() -> this.mailSender.send(message)).start();
    }

    private String mailTemplate(String templateName, Map<String, Object> context) {
        return this.mustacheFactory.compile("mail_templates/" + templateName).execute((Writer)new StringWriter(), context).toString();
    }

    public void sendInviteMailReminder(Action action, String comments) {
        String jiraKey = (String)action.getJiraKey().orElseThrow(() -> new IllegalArgumentException("No jirKey in the ticket"));
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("title", "Herinnering voor de uitnodiging voor een nieuwe SURFconext koppeling");
        variables.put("action", action);
        if (StringUtils.hasText((String)comments)) {
            variables.put("comments", HtmlUtils.htmlEscape((String)comments).replaceAll("\n", "<br/>"));
        }
        variables.put("hasComments", StringUtils.hasText((String)comments));
        variables.put("mailBaseUrl", this.mailBaseUrl);
        variables.put("metaDataType", StringUtils.isEmpty((Object)action.getTypeMetaData()) ? EntityType.saml20_sp.name() : action.getTypeMetaData());
        List emails = Stream.of(action.getEmailTo().split(",")).map(String::trim).collect(Collectors.toList());
        String html = this.mailTemplate("resend_invite_request_nl.html", variables);
        String subject = String.format("Uitnodiging voor een nieuwe SURFconext koppeling met %s (ticket %s)", action.getSpName(), jiraKey);
        try {
            this.sendMail(html, subject, emails, Collections.emptyList(), true, this.emailFrom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendDashboardConnectWithoutInteractionEmail(List<String> emails, String idpName, String spName, String type, String comments, String emailContactPerson) {
        String emailSubject = "Nieuwe SURFconext koppeling";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("title", "Nieuwe SURFconext koppeling");
        variables.put("idpName", idpName);
        variables.put("spName", spName);
        variables.put("comments", comments);
        variables.put("hasComments", StringUtils.hasText((String)comments));
        variables.put("emailContactPerson", emailContactPerson);
        variables.put("hasEmailContactPerson", StringUtils.hasText((String)emailContactPerson));
        String html = this.mailTemplate("new_connection_without_interaction_" + type + "_nl.html", variables);
        try {
            this.sendMail(html, emailSubject, emails, Collections.emptyList(), true, this.emailFrom);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

