/*
 * Decompiled with CFR 0.152.
 */
package dashboard.service.impl;

import com.google.common.collect.ImmutableMap;
import dashboard.domain.Action;
import dashboard.domain.Change;
import dashboard.domain.JiraFilter;
import dashboard.domain.JiraResponse;
import dashboard.service.impl.JiraClient;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraClientMock
implements JiraClient {
    private static final Logger LOG = LoggerFactory.getLogger(JiraClientMock.class);
    private Map<String, Action> repository = new LinkedHashMap();
    private AtomicInteger counter = new AtomicInteger(0);
    private List<String> statuses = Arrays.asList("To Do", "In Progress", "Awaiting Input", "Resolved", "Closed");

    public JiraClientMock(String idp) {
    }

    public String create(Action action, List<Change> changes) {
        String key = this.generateKey();
        this.repository.put(key, action.unbuild().jiraKey(key).body(action.getBody() == null ? "" : action.getBody()).build());
        LOG.debug("Added task (key '{}') to repository: {}", (Object)key, (Object)action);
        return key;
    }

    private String generateKey() {
        return "TASK-" + this.counter.incrementAndGet();
    }

    public JiraResponse searchTasks(String idp, JiraFilter jiraFilter) {
        List actions = this.repository.values().stream().filter(action -> action.getIdpId().equals(idp)).collect(Collectors.toList());
        return new JiraResponse(actions, actions.size(), jiraFilter.getStartAt(), jiraFilter.getMaxResults());
    }

    public Map<String, String> validTransitions(String key) {
        return ImmutableMap.of((Object)"To Do", (Object)"1", (Object)"In Progress", (Object)"2", (Object)"Awaiting Input", (Object)"3", (Object)"Resolved", (Object)"4", (Object)"Closed", (Object)"5");
    }

    public void comment(String key, String comment) {
    }

    public void transition(String key, String transitionId, Optional<String> resolution, Optional<String> comment) {
        Action action = (Action)this.repository.get(key);
        if (action != null) {
            Map transitions = this.validTransitions(key);
            Optional<String> newStatusTxt = transitions.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(transitionId)).map(entry -> (String)entry.getKey()).findAny();
            newStatusTxt.ifPresent(status -> this.repository.put(key, action.unbuild().status(status).build()));
        }
    }

    public void updateOptionalMessage(String jiraKey, String optionalMessage) {
    }
}

