/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dashboard.control.BaseController;
import dashboard.control.RestResponse;
import dashboard.domain.CoinUser;
import dashboard.sab.Sab;
import dashboard.sab.SabPerson;
import dashboard.util.SpringSecurity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/dashboard/api/idp"}, produces={"application/json"})
public class IdpController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(IdpController.class);
    public static final List<String> INTERESTING_ROLES = ImmutableList.of((Object)"SURFconextbeheerder", (Object)"SURFconextverantwoordelijke");
    @Autowired
    private Sab sabClient;

    @RequestMapping(value={"/current/roles"})
    public ResponseEntity<RestResponse<Map<String, Collection<SabPerson>>>> roles(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId) {
        Optional optionalIdentityProvider = SpringSecurity.getCurrentUser().getByEntityId(idpEntityId);
        boolean displayAdminEmailsInDashboard = optionalIdentityProvider.map(idp -> idp.isDisplayAdminEmailsInDashboard()).orElse(false);
        if (SpringSecurity.getCurrentUser().isGuest() || SpringSecurity.getCurrentUser().isDashboardMember() && !displayAdminEmailsInDashboard) {
            return new ResponseEntity((Object)this.createRestResponse(Collections.emptyMap()), HttpStatus.OK);
        }
        Map roleAssignments = optionalIdentityProvider.map(idp -> this.personsInRole(idp.getInstitutionId())).orElse(Collections.emptyMap());
        return new ResponseEntity((Object)this.createRestResponse(roleAssignments), HttpStatus.OK);
    }

    @RequestMapping(value={"/sab/roles"})
    public ResponseEntity<RestResponse<Map<String, Collection<SabPerson>>>> sabRoles(@RequestParam(value="institutionId") String institutionId) {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (!currentUser.isSuperUser()) {
            LOG.warn("Sab roles endpoint is only allowed for superUser, not for {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        Map roles = this.personsInRole(institutionId);
        return new ResponseEntity((Object)this.createRestResponse((Object)roles), HttpStatus.OK);
    }

    private Map<String, Collection<SabPerson>> personsInRole(String institutionId) {
        if (Strings.isNullOrEmpty((String)institutionId)) {
            return ImmutableMap.of();
        }
        return INTERESTING_ROLES.stream().collect(Collectors.toMap(Function.identity(), role -> this.sabClient.getPersonsInRoleForOrganization(institutionId, role)));
    }
}

