/*
 * Decompiled with CFR 0.152.
 */
package dashboard.sab;

import dashboard.sab.SabRole;
import java.util.List;

public class SabPerson {
    private final String firstName;
    private final String middleName;
    private final String surname;
    private final String uid;
    private final String email;
    private final List<SabRole> roles;

    public SabPerson(String firstName, String middleName, String surname, String uid, String email, List<SabRole> roles) {
        this.firstName = firstName;
        this.middleName = middleName;
        this.surname = surname;
        this.uid = uid;
        this.email = email;
        this.roles = roles;
    }

    public String fullname() {
        if (this.middleName.isEmpty()) {
            return String.format("%s %s", this.firstName, this.surname);
        }
        return String.format("%s %s %s", this.firstName, this.middleName, this.surname);
    }

    public boolean hasRole(String roleName) {
        return this.roles.stream().anyMatch(role -> roleName.equals(role.roleName));
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getUid() {
        return this.uid;
    }

    public String getEmail() {
        return this.email;
    }

    public List<SabRole> getRoles() {
        return this.roles;
    }
}

