/*
 * Decompiled with CFR 0.152.
 */
package dashboard.service.impl;

import dashboard.domain.Category;
import dashboard.domain.CategoryValue;
import dashboard.domain.CoinUser;
import dashboard.domain.ContactPerson;
import dashboard.domain.ContactPersonType;
import dashboard.domain.IdentityProvider;
import dashboard.domain.Provider;
import dashboard.domain.Service;
import dashboard.domain.ServiceProvider;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.service.Services;
import dashboard.util.SpringSecurity;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ServicesImpl
implements Services {
    private Manage manage;
    private List<String> guestIdps;
    private Set<String> allowedGuestEntityIds = new HashSet();
    private boolean allowedAllForGuestIdp = false;
    private boolean manageFetched = false;

    public ServicesImpl(Manage manage, List<String> guestIdps) {
        this.manage = manage;
        this.guestIdps = guestIdps;
    }

    public List<Service> getServicesForIdp(String idpEntityId, boolean includeAll, Locale locale) {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        IdentityProvider identityProvider = currentUser.isGuest() ? new IdentityProvider(Collections.singletonMap("eid", 1)) : (IdentityProvider)this.manage.getIdentityProvider(idpEntityId, false).orElseThrow(() -> new IllegalArgumentException(String.format("IDP %s does not exists", idpEntityId)));
        List allServiceProviders = this.manage.getAllServiceProviders();
        Set invitationRequestEntities = currentUser.getInvitationRequestEntities();
        List<Service> services = allServiceProviders.stream().filter(sp -> !sp.isResourceServer() && !sp.isClientCredentials()).map(sp -> {
            Service service = this.buildApiService(sp, locale.getLanguage());
            this.markServiceAsConnected(idpEntityId, identityProvider, sp, service);
            service.setDashboardConnectOption(sp.getDashboardConnectOption());
            return service;
        }).filter(service -> !service.isIdpVisibleOnly() || service.isConnected() || includeAll || service.getInstitutionId() != null && service.getInstitutionId().equals(identityProvider.getInstitutionId()) || invitationRequestEntities != null && invitationRequestEntities.contains(service.getSpEntityId())).collect(Collectors.toList());
        return services;
    }

    public List<Service> getServicesByEntityIds(List<String> entityIds, Locale locale) {
        return this.buildApiServices(this.manage.getByEntityIdin(entityIds), locale.getLanguage());
    }

    public Optional<Service> getServiceByEntityId(String idpEntityId, String spEntityId, EntityType entityType, Locale locale) {
        Optional serviceProvider = this.manage.getServiceProvider(spEntityId, entityType, false);
        return this.enrichService(idpEntityId, locale, serviceProvider);
    }

    public Optional<Service> getServiceById(String idpEntityId, Long spId, EntityType entityType, Locale locale) {
        Optional serviceProvider = this.manage.getServiceProviderById(spId, entityType);
        return this.enrichService(idpEntityId, locale, serviceProvider);
    }

    private void markServiceAsConnected(String idpEntityId, IdentityProvider identityProvider, ServiceProvider sp, Service service) {
        boolean connectedToIdentityProvider = identityProvider.isAllowedAll() || identityProvider.getAllowedEntityIds().contains(sp.getId());
        boolean allowedBySp = sp.isAllowedAll() || sp.getAllowedEntityIds().contains(idpEntityId);
        boolean isSingleTenantTemplate = sp.getEntityType().equals((Object)EntityType.single_tenant_template);
        service.setConnected(connectedToIdentityProvider && allowedBySp && !isSingleTenantTemplate);
    }

    private Optional<Service> enrichService(String idpEntityId, Locale locale, Optional<ServiceProvider> serviceProvider) {
        IdentityProvider identityProvider = SpringSecurity.getCurrentUser().isGuest() ? new IdentityProvider(Collections.singletonMap("eid", 1)) : (IdentityProvider)this.manage.getIdentityProvider(idpEntityId, false).orElseThrow(() -> new IllegalArgumentException(String.format("IDP %s does not exists", idpEntityId)));
        return serviceProvider.map(sp -> {
            Service service = this.buildApiService(sp, locale.getLanguage());
            this.markServiceAsConnected(idpEntityId, identityProvider, sp, service);
            return service;
        });
    }

    public List<Service> getInstitutionalServicesForIdp(String institutionId, Locale locale) {
        List institutionalServicesForIdp = this.manage.getInstitutionalServicesForIdp(institutionId);
        return this.buildApiServices(institutionalServicesForIdp, locale.getLanguage());
    }

    private List<Service> buildApiServices(List<ServiceProvider> services, String language) {
        return services.stream().map(service -> this.buildApiService(service, language)).collect(Collectors.toList());
    }

    private Service buildApiService(ServiceProvider serviceProvider, String locale) {
        Service service = new Service();
        this.plainProperties(serviceProvider, service);
        this.languageSpecificProperties(serviceProvider, locale, service);
        this.categories(serviceProvider, service, locale);
        this.contactPersons(serviceProvider, service);
        return service;
    }

    private void plainProperties(ServiceProvider sp, Service service) {
        service.setSpEntityId(sp.getId());
        service.setState(sp.getState());
        service.setAppUrl(sp.getApplicationUrl());
        service.setId(sp.getEid().longValue());
        service.setEulaUrl(sp.getEulaURL());
        service.setDetailLogoUrl(sp.getLogoUrl());
        service.setLogoUrl(sp.getLogoUrl());
        service.setSupportMail(this.mailOfContactPerson(sp.getContactPerson(ContactPersonType.support)));
        Map homeUrls = sp.getHomeUrls();
        service.setWebsiteUrl(CollectionUtils.isEmpty((Map)homeUrls) ? null : (String)homeUrls.values().iterator().next());
        service.setArp(sp.getArp());
        service.setIdpVisibleOnly(sp.isIdpVisibleOnly());
        service.setPolicyEnforcementDecisionRequired(sp.isPolicyEnforcementDecisionRequired());
        service.setInstitutionId(sp.getInstitutionId());
        service.setPublishedInEdugain(sp.isPublishedInEdugain());
        service.setLicenseStatus(sp.getLicenseStatus());
        service.setEntityType(sp.getEntityType());
        service.setExampleSingleTenant(sp.getEntityType().equals((Object)EntityType.single_tenant_template));
        service.setInterfedSource(sp.getInterfedSource());
        service.setRegistrationInfoUrl(sp.getRegistrationInfo());
        service.setEntityCategories1(sp.getEntityCategories1());
        service.setEntityCategories2(sp.getEntityCategories2());
        service.setEntityCategories3(sp.getEntityCategories3());
        service.setPublishInEdugainDate(sp.getPublishInEdugainDate());
        service.setStrongAuthentication(sp.isStrongAuthenticationEnabled());
        service.setMinimalLoaLevel(sp.getMinimalLoaLevel());
        service.setNames(sp.getNames());
        service.setOrganisations(sp.getOrganisations());
        service.setDescriptions(sp.getDescriptions());
        service.setDisplayNames(sp.getDisplayNames());
        service.setNoConsentRequired(sp.isNoConsentRequired());
        service.setPrivacyInfo(sp.getPrivacyInfo());
        service.setMotivations(sp.getArpMotivations());
        service.setNormenkaderPresent(sp.getPrivacyInfo().isGdprIsInWiki());
        service.setAansluitovereenkomstRefused(sp.isAansluitovereenkomstRefused());
        service.setGuestEnabled(this.isGuestEnabled(sp));
        service.setManipulationNotes(sp.getManipulationNotes());
        service.setContractualBase(sp.getContractualBase());
        service.setDashboardConnectOption(sp.getDashboardConnectOption());
        service.setManipulation(sp.isManipulation());
        service.setNameIds(sp.getNameIds());
        service.setResourceServers(sp.getResourceServers());
        service.setResourceServer(sp.isResourceServer());
    }

    private void initialize() {
        this.guestIdps.stream().map(guestIdp -> this.manage.getIdentityProvider(guestIdp, false)).forEach(identityProviderOptional -> identityProviderOptional.ifPresent(identityProvider -> {
            if (!this.allowedAllForGuestIdp) {
                this.allowedAllForGuestIdp = identityProvider.isAllowedAll();
            }
            if (identityProvider.getAllowedEntityIds() != null) {
                this.allowedGuestEntityIds.addAll(identityProvider.getAllowedEntityIds());
            }
        }));
        this.manageFetched = true;
    }

    private boolean isGuestEnabled(ServiceProvider sp) {
        try {
            if (!this.manageFetched) {
                this.initialize();
            }
        }
        catch (Exception e) {
            this.manageFetched = false;
            return false;
        }
        if (sp.isAllowedAll() && (this.allowedAllForGuestIdp || this.allowedGuestEntityIds.contains(sp.getId()))) {
            return true;
        }
        return sp.getAllowedEntityIds() != null && sp.getAllowedEntityIds().stream().anyMatch(entityId -> this.guestIdps.contains(entityId)) && (this.allowedGuestEntityIds.contains(sp.getId()) || this.allowedAllForGuestIdp);
    }

    private String mailOfContactPerson(ContactPerson contactPerson) {
        return contactPerson == null ? null : contactPerson.getEmailAddress();
    }

    private void languageSpecificProperties(ServiceProvider sp, String locale, Service service) {
        Provider.Language lang = "en".equals(locale) ? Provider.Language.EN : ("pt".equals(locale) ? Provider.Language.PT : Provider.Language.NL);
        service.setDescription(sp.getDescription(lang));
        service.setEnduserDescription(sp.getDescription(lang));
        service.setName(sp.getName(lang));
        service.setOrganisation(sp.getOrganisation(lang));
        service.setSupportUrl(sp.getUrl(lang));
        service.setInstitutionDescription(sp.getDescription(lang));
        service.setServiceUrl(sp.getUrl(lang));
        service.setWikiUrl(sp.getWikiUrl(lang));
        service.setSpName(sp.getName(lang));
        if ("en".equals(locale)) {
            service.setRegistrationPolicyUrl(sp.getRegistrationPolicyUrlEn());
            service.setPrivacyStatementUrl(sp.getPrivacyStatementUrlEn());
        } else if ("pt".equalsIgnoreCase(locale)) {
            service.setRegistrationPolicyUrl(sp.getRegistrationPolicyUrlPt());
            service.setPrivacyStatementUrl(sp.getPrivacyStatementUrlPt());
        } else {
            service.setRegistrationPolicyUrl(sp.getRegistrationPolicyUrlNl());
            service.setPrivacyStatementUrl(sp.getPrivacyStatementUrlNl());
        }
    }

    private void categories(ServiceProvider sp, Service service, String locale) {
        List typeOfServices;
        List list = locale.equals("en") ? sp.getTypeOfServicesEn() : (typeOfServices = locale.equals("pt") ? sp.getTypeOfServicesPt() : sp.getTypeOfServicesNl());
        if (CollectionUtils.isEmpty((Collection)typeOfServices)) {
            typeOfServices.add(locale.equals("en") ? "Other" : (locale.equals("pt") ? "Outro" : "Overig"));
        }
        Category category = new Category(locale.equals("en") ? "Type of Service" : (locale.equals("pt") ? "Tipo de Servi\u00e7o" : "Type Service"), "type_of_service", typeOfServices.stream().map(CategoryValue::new).collect(Collectors.toList()));
        service.setCategories(Collections.singletonList(category));
    }

    private void contactPersons(ServiceProvider sp, Service service) {
        service.setContactPersons(sp.getContactPersons());
    }
}

