/*
 * Decompiled with CFR 0.152.
 */
package dashboard.manage;

import dashboard.domain.IdentityProvider;
import dashboard.domain.ServiceProvider;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.util.SpringSecurity;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class UrlResourceManage
implements Manage {
    private static final Logger LOG = LoggerFactory.getLogger(UrlResourceManage.class);
    private final String manageBaseUrl;
    private final RestTemplate restTemplate = new RestTemplate();
    private final HttpHeaders httpHeaders;
    private String requestedAttributes = "\"ALL_ATTRIBUTES\":true";
    private String body = "{" + this.requestedAttributes + "}";
    private String bodyForEntity = "{\"entityid\":\"@@entityid@@\", " + this.requestedAttributes + "}";
    private String bodyForEid = "{\"eid\":@@eid@@, " + this.requestedAttributes + "}";
    private String bodyForInstitutionId = "{\"metaDataFields.coin:institution_id\":\"@@institution_id@@\", \"ALL_ATTRIBUTES\":true}";
    private String linkedQuery = "{$and: [{$or:[{\"data.allowedEntities.name\": {$in: [\"@@entityid@@\"]}}, {\"data.allowedall\": true}]}]}";
    private String findByEntityIdIn = "{\"data.entityid\":{\"$in\":[@@entityids@@]}}";

    public UrlResourceManage(String username, String password, String manageBaseUrl) {
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode((username + ":" + password).getBytes()));
        this.manageBaseUrl = manageBaseUrl;
        this.httpHeaders = new HttpHeaders();
        this.httpHeaders.add("Content-Type", "application/json");
        this.httpHeaders.add("Authorization", basicAuth);
        SimpleClientHttpRequestFactory requestFactory = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
        requestFactory.setConnectTimeout(10000);
    }

    public List<ServiceProvider> getAllServiceProviders() {
        List providers = this.getMaps(this.getSpInputStream(this.body));
        List singleTenants = this.getMaps(this.getSingleTenantInputStream(this.body));
        List rps = this.getMaps(this.getRPInputStream(this.body));
        List<ServiceProvider> serviceProviders = providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, EntityType.saml20_sp)).filter(sp -> !sp.isHidden()).collect(Collectors.toList());
        List relayingParties = rps.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(rp -> this.serviceProvider(rp, EntityType.oidc10_rp)).filter(rp -> !rp.isHidden()).collect(Collectors.toList());
        List singleTenantsProviders = singleTenants.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, EntityType.single_tenant_template)).collect(Collectors.toList());
        serviceProviders.addAll(singleTenantsProviders);
        serviceProviders.addAll(relayingParties);
        return serviceProviders;
    }

    private InputStream providerInputStream(EntityType type, String body) {
        return type.equals((Object)EntityType.saml20_sp) ? this.getSpInputStream(body) : (type.equals((Object)EntityType.oidc10_rp) ? this.getRPInputStream(body) : this.getSingleTenantInputStream(body));
    }

    public Optional<ServiceProvider> getServiceProvider(String spEntityId, EntityType type, boolean searchRevisions) {
        if (StringUtils.isEmpty((Object)spEntityId)) {
            return Optional.empty();
        }
        String body = this.bodyForEntity.replace("@@entityid@@", spEntityId);
        List providers = this.getMaps(this.providerInputStream(type, body));
        if (providers.isEmpty()) {
            providers = this.getMaps(this.getSpRevisionInputStream(body));
        }
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, type)).findFirst();
    }

    public Optional<ServiceProvider> getServiceProviderById(Long spId, EntityType entityType) {
        if (spId == null) {
            return Optional.empty();
        }
        String body = this.bodyForEid.replace("@@eid@@", spId.toString());
        List providers = this.getMaps(this.providerInputStream(entityType, body));
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, entityType)).findFirst();
    }

    public Optional<IdentityProvider> getIdentityProvider(String idpEntityId, boolean searchRevisions) {
        if (StringUtils.isEmpty((Object)idpEntityId)) {
            return Optional.empty();
        }
        String body = this.bodyForEntity.replace("@@entityid@@", idpEntityId);
        InputStream inputStream = this.getIdpInputStream(body);
        List providers = this.getMaps(inputStream);
        if (providers.isEmpty()) {
            providers = this.getMaps(this.getIdpRevisionInputStream(body));
        }
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).findFirst();
    }

    public List<IdentityProvider> getInstituteIdentityProviders(String instituteId) {
        String body = this.bodyForInstitutionId.replace("@@institution_id@@", instituteId);
        InputStream inputStream = this.getIdpInputStream(body);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).collect(Collectors.toList());
    }

    public List<IdentityProvider> getAllIdentityProviders() {
        InputStream inputStream = this.getIdpInputStream(this.body);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).collect(Collectors.toList());
    }

    public List<IdentityProvider> getLinkedIdentityProviders(String spId) {
        String replaced = this.linkedQuery.replace("@@entityid@@", spId);
        InputStream inputStream = this.getSearchInputStream(replaced, EntityType.saml20_idp);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).collect(Collectors.toList());
    }

    public List<ServiceProvider> getLinkedServiceProviders(String idpId) {
        String query = this.linkedQuery.replace("@@entityid@@", idpId);
        return this.rawSearchProviders(query, new EntityType[]{EntityType.saml20_sp, EntityType.oidc10_rp});
    }

    public List<ServiceProvider> getByEntityIdin(List<String> entityIds) {
        String split = entityIds.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
        String query = this.findByEntityIdIn.replace("@@entityids@@", split);
        return this.rawSearchProviders(query, new EntityType[]{EntityType.saml20_sp, EntityType.oidc10_rp});
    }

    private List<ServiceProvider> rawSearchProviders(String query, EntityType ... types) {
        ArrayList<ServiceProvider> result = new ArrayList<ServiceProvider>();
        Stream.of(types).forEach(type -> {
            List maps = this.getMaps(this.getSearchInputStream(query, type));
            result.addAll(maps.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, type)).collect(Collectors.toList()));
        });
        return result;
    }

    public List<ServiceProvider> getInstitutionalServicesForIdp(String instituteId) {
        String body = this.bodyForInstitutionId.replace("@@institution_id@@", instituteId);
        List providers = this.getMaps(this.providerInputStream(EntityType.saml20_sp, body));
        providers.addAll(this.getMaps(this.providerInputStream(EntityType.oidc10_rp, body)));
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, EntityType.saml20_sp)).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getMaps(InputStream inputStream) {
        try {
            return (List)objectMapper.readValue(inputStream, List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getIdpInputStream(String body) {
        return this.getIdpInputStreamFromCollection(body, "saml20_idp");
    }

    private InputStream getIdpRevisionInputStream(String body) {
        return this.getIdpInputStreamFromCollection(body, "saml20_idp_revision");
    }

    private InputStream getIdpInputStreamFromCollection(String body, String collection) {
        LOG.debug("Fetching IDP metadata entries from {} with body {}", (Object)this.manageBaseUrl);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/" + collection, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    private InputStream getSpInputStream(String body) {
        return this.getSpInputStreamFromCollection(body, "saml20_sp");
    }

    private InputStream getRPInputStream(String body) {
        return this.getSpInputStreamFromCollection(body, "oidc10_rp");
    }

    private InputStream getSpRevisionInputStream(String body) {
        return this.getSpInputStreamFromCollection(body, "saml20_sp_revision");
    }

    private InputStream getSpInputStreamFromCollection(String body, String collection) {
        LOG.debug("Fetching SP metadata entries from {} with body {}", (Object)this.manageBaseUrl, (Object)body);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/" + collection, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    private InputStream getSearchInputStream(String query, EntityType entityType) {
        String url;
        LOG.debug("Quering " + entityType + " metadata entries from {} with query {}", (Object)this.manageBaseUrl, (Object)this.body);
        try {
            url = this.manageBaseUrl + "/manage/api/internal/rawSearch/" + entityType + "?query=" + URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    private InputStream getSingleTenantInputStream(String body) {
        LOG.debug("Fetching Single Tenant Templates metadata entries from {} with body {}", (Object)this.manageBaseUrl, (Object)body);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/single_tenant_template", HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    public String connectWithoutInteraction(String idpId, String spId, String type) {
        try {
            String url = this.manageBaseUrl + "/manage/api/internal/connectWithoutInteraction/";
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("idpId", idpId);
            body.put("spId", spId);
            body.put("spType", type);
            body.put("user", SpringSecurity.getCurrentUser().getDisplayName());
            body.put("userUrn", SpringSecurity.getCurrentUser().getUid());
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.PUT, new HttpEntity(body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                return "success";
            }
        }
        catch (Exception e) {
            LOG.error("Exception in Manage connectWithoutInteraction", (Throwable)e);
        }
        return "failure";
    }
}

