/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import dashboard.control.BaseController;
import dashboard.domain.Action;
import dashboard.domain.ContactPerson;
import dashboard.domain.ContactPersonType;
import dashboard.domain.IdentityProvider;
import dashboard.domain.InviteRequest;
import dashboard.domain.ServiceConnectionRequest;
import dashboard.domain.ServiceProvider;
import dashboard.mail.MailBox;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.sab.Sab;
import dashboard.service.ActionsService;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/spDashboard/api/"})
@RestController
public class SpDashboardController
extends BaseController {
    private static final Logger LOG = LoggerFactory.getLogger(SpDashboardController.class);
    private ActionsService actionsService;
    private MailBox mailbox;
    private Sab sabClient;
    private String spApiUsername;
    private String spApiPassword;
    private Manage manage;

    public SpDashboardController(ActionsService actionsService, MailBox mailbox, Sab sabClient, Manage manage, @Value(value="${spDashboard.username}") String spApiUsername, @Value(value="${spDashboard.password}") String spApiPassword) {
        this.actionsService = actionsService;
        this.mailbox = mailbox;
        this.sabClient = sabClient;
        this.spApiUsername = spApiUsername;
        this.spApiPassword = spApiPassword;
        this.manage = manage;
    }

    @RequestMapping(value={"serviceConnectionRequest"}, method={RequestMethod.PUT})
    public ResponseEntity connectionRequest(@RequestBody ServiceConnectionRequest serviceConnectionRequest, HttpServletRequest request) {
        LOG.debug("authenticating serviceProvider request from sp: " + serviceConnectionRequest.getSpEntityId());
        if (this.invalidUser(request)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
        String idpEntityId = serviceConnectionRequest.getIdpEntityId();
        Collection sabPersons = this.sabClient.getSabEmailsForOrganization(idpEntityId, "SURFconextverantwoordelijke");
        Optional optionalIdp = this.manage.getIdentityProvider(idpEntityId, false);
        String spEntityId = serviceConnectionRequest.getSpEntityId();
        Optional optionalSp = this.manage.getServiceProvider(spEntityId, EntityType.valueOf((String)serviceConnectionRequest.getTypeMetaData()), false);
        if (!optionalSp.isPresent() || !optionalIdp.isPresent()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).build();
        }
        IdentityProvider idp = (IdentityProvider)optionalIdp.get();
        ServiceProvider sp = (ServiceProvider)optionalSp.get();
        String idpName = idp.getName();
        String spName = sp.getName();
        List contactPersons = sabPersons.stream().map(ContactPerson::new).collect(Collectors.toList());
        List contactPersonsFromIdp = idp.getContactPersons();
        if (!CollectionUtils.isEmpty((Collection)contactPersonsFromIdp)) {
            contactPersons.addAll(contactPersonsFromIdp.stream().filter(cp -> cp.getContactPersonType().equals((Object)ContactPersonType.administrative)).collect(Collectors.toList()));
        }
        Action action = Action.builder().userEmail(serviceConnectionRequest.getOwnEmail()).userName(serviceConnectionRequest.getOwnName()).emailTo(contactPersons.stream().map(ContactPerson::getEmailAddress).collect(Collectors.joining(", "))).typeMetaData(serviceConnectionRequest.getTypeMetaData()).idpId(idpEntityId).spId(spEntityId).type(Action.Type.LINKINVITE).build();
        action = this.actionsService.create(action, Collections.emptyList());
        InviteRequest inviteRequest = new InviteRequest(serviceConnectionRequest, String.valueOf(sp.getEid()), idpName, spName, contactPersons);
        this.mailbox.sendInviteMail(inviteRequest, action);
        return ResponseEntity.ok(Collections.singletonMap("jiraKey", (String)action.getJiraKey().get()));
    }

    private boolean invalidUser(HttpServletRequest request) {
        String header = request.getHeader("Authorization");
        if (header == null || !header.startsWith("Basic ")) {
            return true;
        }
        byte[] base64Token = header.substring(6).getBytes(Charset.defaultCharset());
        byte[] decoded = Base64.getDecoder().decode(base64Token);
        String token = new String(decoded, Charset.defaultCharset());
        String user = token.split(":")[0];
        String password = token.split(":")[1];
        return !user.equals(this.spApiUsername) || !password.equals(this.spApiPassword);
    }
}

