/*
 * Decompiled with CFR 0.152.
 */
package dashboard.domain;

import dashboard.domain.Action;
import dashboard.domain.Consent;
import dashboard.domain.Service;
import dashboard.domain.Settings;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Optional;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class Action {
    private String jiraKey;
    private String userName;
    private String userEmail;
    private String emailTo;
    private boolean shouldSendEmail;
    private boolean connectWithoutInteraction;
    private String body;
    private String personalMessage;
    private String emailContactPerson;
    private String idpId;
    private String spId;
    private Long spEid;
    private String idpName;
    private String spName;
    private String typeMetaData;
    private ZonedDateTime requestDate;
    private ZonedDateTime updateDate;
    private Type type;
    private String status;
    private String resolution;
    private String subject;
    private Service service;
    private Settings settings;
    private Consent consent;
    private String loaLevel;
    private boolean rejected;

    private Action(Builder builder) {
        this.jiraKey = builder.jiraKey;
        this.userName = builder.userName;
        this.userEmail = builder.userEmail;
        this.emailTo = builder.emailTo;
        this.shouldSendEmail = builder.shouldSendEmail;
        this.connectWithoutInteraction = builder.connectWithoutInteraction;
        this.body = builder.body;
        this.personalMessage = builder.personalMessage;
        this.emailContactPerson = builder.emailContactPerson;
        this.idpId = builder.idpId;
        this.spId = builder.spId;
        this.spEid = builder.spEid;
        this.spName = builder.spName;
        this.typeMetaData = builder.typeMetaData;
        this.idpName = builder.idpName;
        this.requestDate = builder.requestDate;
        this.updateDate = builder.updateDate;
        this.type = builder.type;
        this.status = builder.status;
        this.resolution = builder.resolution;
        this.service = builder.service;
        this.settings = builder.settings;
        this.consent = builder.consent;
        this.rejected = builder.rejected;
    }

    public Optional<String> getJiraKey() {
        return Optional.ofNullable(this.jiraKey);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getBody() {
        return this.body;
    }

    public String getPersonalMessage() {
        return this.personalMessage;
    }

    public String getEmailContactPerson() {
        return this.emailContactPerson;
    }

    public String getIdpId() {
        return this.idpId;
    }

    public String getSpId() {
        return this.spId;
    }

    public String getIdpName() {
        return this.idpName;
    }

    public Long getSpEid() {
        return this.spEid;
    }

    public String getTypeMetaData() {
        return this.typeMetaData;
    }

    public ZonedDateTime getRequestDate() {
        return this.requestDate;
    }

    public ZonedDateTime getUpdateDate() {
        return this.updateDate;
    }

    public Type getType() {
        return this.type;
    }

    public String getStatus() {
        return this.status;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public String getEmailTo() {
        return this.emailTo;
    }

    public boolean shouldSendEmail() {
        return this.shouldSendEmail;
    }

    public boolean connectWithoutInteraction() {
        return this.connectWithoutInteraction;
    }

    public String getSubject() {
        return this.subject;
    }

    public Service getService() {
        return this.service;
    }

    public String getSpName() {
        return this.spName;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public Consent getConsent() {
        return this.consent;
    }

    public String getLoaLevel() {
        return this.loaLevel;
    }

    public static Comparator<? super Action> sortByDateAsc() {
        return (a1, a2) -> new CompareToBuilder().append((Object)a1.getRequestDate(), (Object)a2.getRequestDate()).toComparison();
    }

    public String toString() {
        return "Action{jiraKey='" + this.jiraKey + "', userName='" + this.userName + "', userEmail='" + this.userEmail + "', body='" + this.body + "', idpId='" + this.idpId + "', spId='" + this.spId + "', idpName='" + this.idpName + "', spName='" + this.spName + "', requestDate=" + this.requestDate + ", updateDate=" + this.updateDate + ", type=" + this.type + ", status='" + this.status + "', subject='" + this.subject + "', service=" + this.service + ", settings=" + this.settings + ", consent=" + this.consent + ", rejected=" + this.rejected + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.idpId == null ? 0 : this.idpId.hashCode());
        result = 31 * result + (this.idpName == null ? 0 : this.idpName.hashCode());
        result = 31 * result + (this.jiraKey == null ? 0 : this.jiraKey.hashCode());
        result = 31 * result + (this.requestDate == null ? 0 : this.requestDate.hashCode());
        result = 31 * result + (this.spId == null ? 0 : this.spId.hashCode());
        result = 31 * result + (this.spName == null ? 0 : this.spName.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.subject == null ? 0 : this.subject.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.userEmail == null ? 0 : this.userEmail.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Action other = (Action)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        if (this.idpId == null ? other.idpId != null : !this.idpId.equals(other.idpId)) {
            return false;
        }
        if (this.idpName == null ? other.idpName != null : !this.idpName.equals(other.idpName)) {
            return false;
        }
        if (this.jiraKey == null ? other.jiraKey != null : !this.jiraKey.equals(other.jiraKey)) {
            return false;
        }
        if (this.requestDate == null ? other.requestDate != null : !this.requestDate.equals(other.requestDate)) {
            return false;
        }
        if (this.spId == null ? other.spId != null : !this.spId.equals(other.spId)) {
            return false;
        }
        if (this.spName == null ? other.spName != null : !this.spName.equals(other.spName)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.subject == null ? other.subject != null : !this.subject.equals(other.subject)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.userEmail == null ? other.userEmail != null : !this.userEmail.equals(other.userEmail)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public Builder unbuild() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }
}

