/*
 * Decompiled with CFR 0.152.
 */
package dashboard.manage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import dashboard.domain.Consent;
import dashboard.domain.ConsentType;
import dashboard.domain.IdentityProvider;
import dashboard.domain.Provider;
import dashboard.domain.ServiceProvider;
import dashboard.manage.ChangeRequest;
import dashboard.manage.EntityType;
import dashboard.manage.PathUpdateType;
import dashboard.util.SpringSecurity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;

public interface Manage {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    public List<ServiceProvider> getAllServiceProviders();

    public Optional<ServiceProvider> getServiceProvider(String var1, EntityType var2, boolean var3);

    public Optional<ServiceProvider> getServiceProviderById(Long var1, EntityType var2);

    public Optional<IdentityProvider> getIdentityProvider(String var1, boolean var2);

    public List<IdentityProvider> getInstituteIdentityProviders(String var1);

    public List<ServiceProvider> getInstitutionalServicesForIdp(String var1);

    public List<IdentityProvider> getAllIdentityProviders();

    public List<IdentityProvider> getLinkedIdentityProviders(String var1);

    public List<ServiceProvider> getLinkedServiceProviders(String var1);

    public List<ServiceProvider> getByEntityIdin(List<String> var1);

    default public ServiceProvider serviceProvider(Map<String, Object> map, EntityType entityType) {
        ServiceProvider serviceProvider = new ServiceProvider(map);
        serviceProvider.setEntityType(entityType);
        return serviceProvider;
    }

    default public IdentityProvider identityProvider(Map<String, Object> map) {
        return new IdentityProvider(map);
    }

    default public <T extends Provider> Map<String, T> parseProviders(Resource resource, Function<Map<String, Object>, T> provider) throws IOException {
        List providers = (List)objectMapper.readValue(resource.getInputStream(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Map result = providers.stream().map(arg_0 -> this.transformManageMetadata(arg_0)).map(provider).collect(Collectors.toSet()).stream().collect(Collectors.toMap(Provider::getId, Function.identity()));
        return result;
    }

    default public Map<String, Object> transformManageMetadata(Map<String, Object> metadata) {
        Map data = (Map)metadata.get("data");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("internalId", metadata.get("_id"));
        data.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                result.put(key, (Boolean)Boolean.class.cast(value) != false ? "yes" : "no");
            } else if (value instanceof String) {
                result.put(key, value);
            } else if (value instanceof Number) {
                result.put(key, value);
            }
            switch (key) {
                case "metaDataFields": {
                    Map metaDataFields = (Map)value;
                    result.putAll(metaDataFields);
                    break;
                }
                case "arp": {
                    Map arp = (Map)value;
                    Boolean enabled = (Boolean)arp.get("enabled");
                    if (!enabled.booleanValue()) break;
                    Object attributesValue = arp.get("attributes");
                    if (attributesValue instanceof Map) {
                        Map attributes = (Map)attributesValue;
                        Map<String, List> attributesMap = attributes.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((List)e.getValue()).stream().map(m -> (String)m.get("value")).collect(Collectors.toList())));
                        Map<String, String> motivationsMap = attributes.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Map)((List)e.getValue()).get(0)).getOrDefault("motivation", "")));
                        Map<String, String> sourcesMap = attributes.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((Map)((List)e.getValue()).get(0)).getOrDefault("source", "idp")));
                        result.put("attributes", attributesMap);
                        result.put("motivations", motivationsMap);
                        result.put("sources", sourcesMap);
                        break;
                    }
                    result.put("attributes", new HashMap());
                    result.put("motivations", new HashMap());
                    result.put("sources", new HashMap());
                    break;
                }
                case "allowedEntities": {
                    List allowedEntities = (List)value;
                    List allowedEntitiesList = allowedEntities.stream().map(m -> (String)m.get("name")).collect(Collectors.toList());
                    result.put("allowedEntities", allowedEntitiesList);
                    break;
                }
                case "disableConsent": {
                    List disableConsent = (List)value;
                    result.put("disableConsent", disableConsent.stream().map(m -> new Consent((String)m.get("name"), m.containsKey("type") ? ConsentType.valueOf((String)((String)m.get("type")).toUpperCase()) : ConsentType.DEFAULT_CONSENT, (String)m.get("explanation:nl"), (String)m.get("explanation:en"), (String)m.get("explanation:pt"), EntityType.saml20_sp.name())).collect(Collectors.toList()));
                    break;
                }
                case "stepupEntities": {
                    List stepupEntities = (List)value;
                    result.put("stepupEntities", stepupEntities);
                    break;
                }
                case "mfaEntities": {
                    List mfaEntities = (List)value;
                    result.put("mfaEntities", mfaEntities);
                    break;
                }
                case "allowedResourceServers": {
                    List allowedResourceServers = (List)value;
                    result.put("allowedResourceServers", allowedResourceServers.stream().map(rs -> (String)rs.get("name")).collect(Collectors.toList()));
                    break;
                }
            }
        });
        return result;
    }

    public void connectWithoutInteraction(String var1, String var2, String var3, Optional<String> var4);

    public Map<String, Object> createChangeRequests(ChangeRequest var1);

    public List<String> createConnectionRequests(IdentityProvider var1, String var2, EntityType var3, String var4, Optional<String> var5);

    public List<String> deactivateConnectionRequests(IdentityProvider var1, String var2, EntityType var3, String var4);

    default public Optional<ChangeRequest> changeRequestForAllowedEntity(Provider source, Provider target, String note, boolean add) {
        if (source.isAllowedAll()) {
            return Optional.empty();
        }
        Map<String, Map<String, String>> pathUpdates = Map.of("allowedEntities", Map.of("name", target.getId()));
        Map<String, String> auditData = Collections.singletonMap("userName", SpringSecurity.getCurrentUser().getUid());
        return Optional.of(new ChangeRequest(source.getInternalId(), source.getEntityType().name(), note, pathUpdates, auditData, true, add ? PathUpdateType.ADDITION : PathUpdateType.REMOVAL));
    }

    default public List<ChangeRequest> allowedEntityChangeRequest(IdentityProvider identityProvider, String spEntityId, EntityType spEntityType, String note, boolean add) {
        ServiceProvider serviceProvider = (ServiceProvider)this.getServiceProvider(spEntityId, spEntityType, false).orElseThrow(IllegalArgumentException::new);
        ArrayList<ChangeRequest> changeRequests = new ArrayList<ChangeRequest>();
        this.changeRequestForAllowedEntity((Provider)identityProvider, (Provider)serviceProvider, note, add).ifPresent(changeRequests::add);
        this.changeRequestForAllowedEntity((Provider)serviceProvider, (Provider)identityProvider, note, add).ifPresent(changeRequests::add);
        return changeRequests;
    }
}

