/*
 * Decompiled with CFR 0.152.
 */
package dashboard.pdp;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import dashboard.domain.Attribute;
import dashboard.domain.Policy;
import dashboard.domain.Service;
import dashboard.manage.EntityType;
import dashboard.pdp.PdpService;
import dashboard.pdp.PolicyNameNotUniqueException;
import dashboard.service.Services;
import dashboard.util.SpringSecurity;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;

public class PdpServiceMock
implements PdpService {
    private static final List<Attribute> ALLOWED_ATTRIBUTES = ImmutableList.of((Object)new Attribute("urn:mace:terena.org:attribute-def:schacHomeOrganization", "Schac home organization"), (Object)new Attribute("urn:mace:terena.org:attribute-def:schacHomeOrganizationType", "Schac home organization type"), (Object)new Attribute("urn:mace:dir:attribute-def:eduPersonAffiliation", "Edu person affiliation"), (Object)new Attribute("urn:mace:dir:attribute-def:eduPersonScopedAffiliation", "Edu person scoped affiliation"));
    private final ListMultimap<Long, Policy> policies = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    @Autowired
    private Services services;

    public List<Policy> policies() {
        return this.policies.keySet().stream().map(key -> (Policy)Iterables.getLast((Iterable)this.policies.get(key))).collect(Collectors.toList());
    }

    public Policy policy(Long id) {
        return Optional.ofNullable(this.policies.get((Object)id)).map(Iterables::getLast).orElseThrow(RuntimeException::new);
    }

    public Policy create(Policy policy) {
        this.policies.values().stream().filter(p -> p.getName().equals(policy.getName())).findAny().ifPresent(duplicate -> {
            throw new PolicyNameNotUniqueException(String.format("Policy name '%s' already exists", policy.getName()));
        });
        Policy policyWithId = this.savePolicy(policy);
        this.policies.put((Object)policyWithId.getId(), (Object)policyWithId);
        return policyWithId;
    }

    public Policy update(Policy policy) {
        Policy updatedPolicy = this.updatePolicy(policy);
        this.policies.put((Object)policy.getId(), (Object)updatedPolicy);
        return policy;
    }

    public List<Attribute> allowedAttributes() {
        return ALLOWED_ATTRIBUTES;
    }

    public ResponseEntity<String> delete(Long id) {
        this.policies.removeAll((Object)id);
        return null;
    }

    public List<Policy> revisions(Long id) {
        return Optional.ofNullable(this.policies.get((Object)id)).orElseThrow(RuntimeException::new);
    }

    public boolean isAvailable() {
        return true;
    }

    private Policy savePolicy(Policy policy) {
        Long id = this.policies.keySet().stream().max(Long::compare).map(l -> l + 1L).orElse(1L);
        policy.setId(id);
        policy.setUserDisplayName(SpringSecurity.getCurrentUser().getDisplayName());
        policy.setCreated(String.valueOf(System.currentTimeMillis()));
        policy.setActionsAllowed(true);
        policy.setServiceProviderName(this.services.getServiceByEntityId(SpringSecurity.getCurrentUser().getIdp().getId(), policy.getServiceProviderId(), EntityType.saml20_sp, Locale.ENGLISH).map(Service::getName).orElse("????"));
        return policy;
    }

    private Policy updatePolicy(Policy policy) {
        policy.setId(policy.getId());
        policy.setUserDisplayName(SpringSecurity.getCurrentUser().getDisplayName());
        policy.setCreated(String.valueOf(System.currentTimeMillis()));
        policy.setActionsAllowed(true);
        policy.setServiceProviderName(this.services.getServiceByEntityId(SpringSecurity.getCurrentUser().getIdp().getId(), policy.getServiceProviderId(), EntityType.saml20_sp, Locale.ENGLISH).map(Service::getName).orElse("????"));
        policy.setRevisionNbr(policy.getRevisionNbr() + 1);
        policy.setNumberOfRevisions(policy.getNumberOfRevisions() + 1);
        return policy;
    }
}

