/*
 * Decompiled with CFR 0.152.
 */
package dashboard.mail;

import dashboard.mail.MailBox;
import dashboard.mail.MockMailBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mail.MailProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
@EnableConfigurationProperties(value={MailProperties.class})
public class MailConfiguration {
    @Value(value="${systemEmail}")
    private String emailFrom;
    @Value(value="${coin-administrative-email}")
    private String administrativeEmail;
    @Value(value="${mailBaseUrl}")
    private String mailBaseUrl;
    @Autowired
    private JavaMailSender mailSender;

    @ConditionalOnProperty(prefix="dashboard.feature", name={"mail"}, havingValue="true")
    @Bean
    public MailBox mailBox() {
        return new MailBox(this.mailSender, this.emailFrom, this.administrativeEmail, this.mailBaseUrl);
    }

    @ConditionalOnProperty(prefix="dashboard.feature", name={"mail"}, havingValue="false")
    @Bean
    public MailBox mockMailBox() {
        return new MockMailBox(this.mailSender, this.emailFrom, this.administrativeEmail, this.mailBaseUrl);
    }
}

