/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import com.fasterxml.jackson.databind.ObjectMapper;
import dashboard.Application;
import dashboard.manage.ClassPathResourceManage;
import dashboard.manage.Manage;
import dashboard.manage.UrlResourceManage;
import dashboard.pdp.PdpManage;
import dashboard.pdp.PdpService;
import dashboard.pdp.PdpServiceImpl;
import dashboard.pdp.PdpServiceMock;
import dashboard.pdp.PolicyDataSource;
import dashboard.sab.HttpClientTransport;
import dashboard.sab.Sab;
import dashboard.sab.SabClient;
import dashboard.sab.SabClientMock;
import dashboard.sab.SabTransport;
import dashboard.service.Services;
import dashboard.service.impl.Environment;
import dashboard.service.impl.JiraClient;
import dashboard.service.impl.JiraClientImpl;
import dashboard.service.impl.JiraClientMock;
import dashboard.service.impl.ServicesImpl;
import dashboard.stats.Stats;
import dashboard.stats.StatsImpl;
import dashboard.stats.StatsMock;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(exclude={SecurityAutoConfiguration.class, FreeMarkerAutoConfiguration.class})
public class Application {
    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public Services services(Manage manage, @Value(value="${guestidp.entityids}") String guestIdps) {
        return new ServicesImpl(manage, Arrays.stream(guestIdps.split(",")).map(String::trim).collect(Collectors.toList()));
    }

    @Bean
    public Sab sab(HttpClientTransport httpClientTransport, @Value(value="${dashboard.feature.sab}") boolean sabEnabled) {
        return sabEnabled ? new SabClient((SabTransport)httpClientTransport) : new SabClientMock();
    }

    @Bean
    public Manage manage(@Value(value="${dashboard.feature.manage}") boolean manageEnabled, @Value(value="${manage.username}") String username, @Value(value="${manage.password}") String password, @Value(value="${manage.manageBaseUrl}") String manageBaseUrl) {
        return manageEnabled ? new UrlResourceManage(username, password, manageBaseUrl) : new ClassPathResourceManage();
    }

    @Bean
    @Autowired
    public Stats stats(@Value(value="${dashboard.feature.statistics}") boolean statsEnabled, @Value(value="${statsUser}") String user, @Value(value="${statsPassword}") String password, @Value(value="${statsBaseUrl}") String baseUrl, Manage manage) {
        return statsEnabled ? new StatsImpl(user, password, baseUrl) : new StatsMock(manage);
    }

    @Bean
    public JiraClient jiraClient(ObjectMapper objectMapper, @Value(value="${dashboard.feature.jira}") boolean jiraEnabled, @Value(value="${jiraBaseUrl}") String baseUrl, @Value(value="${jiraUsername}") String username, @Value(value="${jiraPassword}") String password, @Value(value="${jiraProjectKey}") String projectKey, @Value(value="${jiraApikey}") String jiraApikey, @Value(value="${jiraUseApiKey}") boolean jiraUseApiKey, @Value(value="${jiraEnvironment}") Environment environment, @Value(value="${jiraDueDateWeeks}") int dueDateWeeks) throws IOException {
        return jiraEnabled ? new JiraClientImpl(objectMapper, baseUrl, username, password, jiraApikey, jiraUseApiKey, projectKey, dueDateWeeks, environment) : new JiraClientMock("http://mock-idp");
    }

    @Bean
    public PdpService pdpService(ObjectMapper objectMapper, @Value(value="${dashboard.feature.pdpSource}") PolicyDataSource policyDataSource, @Value(value="${pdp.server}") String pdpBaseUrl, @Value(value="${pdp.username}") String pdpUsername, @Value(value="${pdp.password}") String pdpPassword, @Value(value="${manage.manageBaseUrl}") String manageBaseUrl, @Value(value="${manage.username}") String manageUsername, @Value(value="${manage.password}") String managePassword) {
        switch (1.$SwitchMap$dashboard$pdp$PolicyDataSource[policyDataSource.ordinal()]) {
            case 1: {
                return new PdpServiceImpl(objectMapper, pdpBaseUrl, pdpUsername, pdpPassword);
            }
            case 2: {
                return new PdpServiceMock();
            }
            case 3: {
                return new PdpManage(objectMapper, manageBaseUrl, manageUsername, managePassword);
            }
        }
        throw new IllegalArgumentException();
    }
}

