/*
 * Decompiled with CFR 0.152.
 */
package dashboard.manage;

import dashboard.domain.IdentityProvider;
import dashboard.domain.ServiceProvider;
import dashboard.manage.AuditData;
import dashboard.manage.ChangeRequest;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.manage.PathUpdateType;
import dashboard.util.SpringSecurity;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class UrlResourceManage
implements Manage {
    private static final Logger LOG = LoggerFactory.getLogger(UrlResourceManage.class);
    private final String manageBaseUrl;
    private final RestTemplate restTemplate = new RestTemplate();
    private final HttpHeaders httpHeaders;
    private final String requestedAttributes = "\"ALL_ATTRIBUTES\":true";
    private final String body = "{\"ALL_ATTRIBUTES\":true}";
    private final String bodyForEntity = "{\"entityid\":\"@@entityid@@\", \"ALL_ATTRIBUTES\":true}";
    private final String bodyForInstitutionId = "{\"metaDataFields.coin:institution_id\":\"@@institution_id@@\", \"ALL_ATTRIBUTES\":true}";
    private final String linkedQuery = "{$and: [{$or:[{\"data.allowedEntities.name\": {$in: [\"@@entityid@@\"]}}, {\"data.allowedall\": true}]}]}";

    public UrlResourceManage(String username, String password, String manageBaseUrl) {
        this.manageBaseUrl = manageBaseUrl;
        this.httpHeaders = new HttpHeaders();
        this.httpHeaders.add("Content-Type", "application/json");
        this.httpHeaders.setBasicAuth(username, password);
        SimpleClientHttpRequestFactory requestFactory = (SimpleClientHttpRequestFactory)this.restTemplate.getRequestFactory();
        requestFactory.setConnectTimeout(10000);
    }

    public List<ServiceProvider> getAllServiceProviders() {
        List providers = this.getMaps(this.getSpInputStream("{\"ALL_ATTRIBUTES\":true}"));
        List singleTenants = this.getMaps(this.getSingleTenantInputStream("{\"ALL_ATTRIBUTES\":true}"));
        List rps = this.getMaps(this.getRPInputStream("{\"ALL_ATTRIBUTES\":true}"));
        List<ServiceProvider> serviceProviders = providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, EntityType.saml20_sp)).filter(sp -> !sp.isHidden()).collect(Collectors.toList());
        List relayingParties = rps.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(rp -> this.serviceProvider(rp, EntityType.oidc10_rp)).filter(rp -> !rp.isHidden()).collect(Collectors.toList());
        List singleTenantsProviders = singleTenants.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, EntityType.single_tenant_template)).collect(Collectors.toList());
        serviceProviders.addAll(singleTenantsProviders);
        serviceProviders.addAll(relayingParties);
        return serviceProviders;
    }

    private InputStream providerInputStream(EntityType type, String body) {
        return type.equals((Object)EntityType.saml20_sp) ? this.getSpInputStream(body) : (type.equals((Object)EntityType.oidc10_rp) ? this.getRPInputStream(body) : this.getSingleTenantInputStream(body));
    }

    public Optional<ServiceProvider> getServiceProvider(String spEntityId, EntityType type, boolean searchRevisions) {
        if (!StringUtils.hasText((String)spEntityId)) {
            return Optional.empty();
        }
        String body = "{\"entityid\":\"@@entityid@@\", \"ALL_ATTRIBUTES\":true}".replace("@@entityid@@", spEntityId);
        List providers = this.getMaps(this.providerInputStream(type, body));
        if (providers.isEmpty()) {
            providers = this.getMaps(this.getSpRevisionInputStream(body));
        }
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, type)).findFirst();
    }

    public Optional<ServiceProvider> getServiceProviderById(Long spId, EntityType entityType) {
        if (spId == null) {
            return Optional.empty();
        }
        String bodyForEid = "{\"eid\":@@eid@@, \"ALL_ATTRIBUTES\":true}";
        String body = bodyForEid.replace("@@eid@@", spId.toString());
        List providers = this.getMaps(this.providerInputStream(entityType, body));
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, entityType)).findFirst();
    }

    public Optional<IdentityProvider> getIdentityProvider(String idpEntityId, boolean searchRevisions) {
        if (!StringUtils.hasText((String)idpEntityId)) {
            return Optional.empty();
        }
        String body = "{\"entityid\":\"@@entityid@@\", \"ALL_ATTRIBUTES\":true}".replace("@@entityid@@", idpEntityId);
        InputStream inputStream = this.getIdpInputStream(body);
        List providers = this.getMaps(inputStream);
        if (providers.isEmpty()) {
            providers = this.getMaps(this.getIdpRevisionInputStream(body));
        }
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).findFirst();
    }

    public List<IdentityProvider> getInstituteIdentityProviders(String instituteId) {
        String body = "{\"metaDataFields.coin:institution_id\":\"@@institution_id@@\", \"ALL_ATTRIBUTES\":true}".replace("@@institution_id@@", instituteId);
        InputStream inputStream = this.getIdpInputStream(body);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).collect(Collectors.toList());
    }

    public List<IdentityProvider> getAllIdentityProviders() {
        InputStream inputStream = this.getIdpInputStream("{\"ALL_ATTRIBUTES\":true}");
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).collect(Collectors.toList());
    }

    public List<IdentityProvider> getLinkedIdentityProviders(String spId) {
        String replaced = "{$and: [{$or:[{\"data.allowedEntities.name\": {$in: [\"@@entityid@@\"]}}, {\"data.allowedall\": true}]}]}".replace("@@entityid@@", spId);
        InputStream inputStream = this.getSearchInputStream(replaced, EntityType.saml20_idp);
        List providers = this.getMaps(inputStream);
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(arg_0 -> ((UrlResourceManage)this).identityProvider(arg_0)).collect(Collectors.toList());
    }

    public List<ServiceProvider> getLinkedServiceProviders(String idpId) {
        String query = "{$and: [{$or:[{\"data.allowedEntities.name\": {$in: [\"@@entityid@@\"]}}, {\"data.allowedall\": true}]}]}".replace("@@entityid@@", idpId);
        return this.rawSearchProviders(query, new EntityType[]{EntityType.saml20_sp, EntityType.oidc10_rp});
    }

    public List<ServiceProvider> getByEntityIdin(List<String> entityIds) {
        String split = entityIds.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
        String findByEntityIdIn = "{\"data.entityid\":{\"$in\":[@@entityids@@]}}";
        String query = findByEntityIdIn.replace("@@entityids@@", split);
        return this.rawSearchProviders(query, new EntityType[]{EntityType.saml20_sp, EntityType.oidc10_rp, EntityType.oauth20_rs});
    }

    private List<ServiceProvider> rawSearchProviders(String query, EntityType ... types) {
        ArrayList<ServiceProvider> result = new ArrayList<ServiceProvider>();
        Stream.of(types).forEach(type -> {
            List maps = this.getMaps(this.getSearchInputStream(query, type));
            result.addAll(maps.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, type)).collect(Collectors.toList()));
        });
        return result;
    }

    public List<ServiceProvider> getInstitutionalServicesForIdp(String instituteId) {
        String body = "{\"metaDataFields.coin:institution_id\":\"@@institution_id@@\", \"ALL_ATTRIBUTES\":true}".replace("@@institution_id@@", instituteId);
        List providers = this.getMaps(this.providerInputStream(EntityType.saml20_sp, body));
        providers.addAll(this.getMaps(this.providerInputStream(EntityType.oidc10_rp, body)));
        return providers.stream().map(arg_0 -> ((UrlResourceManage)this).transformManageMetadata(arg_0)).map(sp -> this.serviceProvider(sp, EntityType.saml20_sp)).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getMaps(InputStream inputStream) {
        try {
            return (List)objectMapper.readValue(inputStream, List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getIdpInputStream(String body) {
        return this.getIdpInputStreamFromCollection(body, "saml20_idp");
    }

    private InputStream getIdpRevisionInputStream(String body) {
        return this.getIdpInputStreamFromCollection(body, "saml20_idp_revision");
    }

    private InputStream getIdpInputStreamFromCollection(String body, String collection) {
        LOG.debug("Fetching IDP metadata entries from {} with body {}", (Object)this.manageBaseUrl);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/" + collection, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    private InputStream getSpInputStream(String body) {
        return this.getSpInputStreamFromCollection(body, "saml20_sp");
    }

    private InputStream getRPInputStream(String body) {
        return this.getSpInputStreamFromCollection(body, "oidc10_rp");
    }

    private InputStream getSpRevisionInputStream(String body) {
        return this.getSpInputStreamFromCollection(body, "saml20_sp_revision");
    }

    private InputStream getSpInputStreamFromCollection(String body, String collection) {
        LOG.debug("Fetching SP metadata entries from {} with body {}", (Object)this.manageBaseUrl, (Object)body);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/" + collection, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    private InputStream getSearchInputStream(String query, EntityType entityType) {
        String url;
        LOG.debug("Quering " + entityType + " metadata entries from {} with query {}", (Object)this.manageBaseUrl, (Object)"{\"ALL_ATTRIBUTES\":true}");
        try {
            url = this.manageBaseUrl + "/manage/api/internal/rawSearch/" + entityType + "?query=" + URLEncoder.encode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, new HttpEntity((MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    private InputStream getSingleTenantInputStream(String body) {
        LOG.debug("Fetching Single Tenant Templates metadata entries from {} with body {}", (Object)this.manageBaseUrl, (Object)body);
        ResponseEntity responseEntity = this.restTemplate.exchange(this.manageBaseUrl + "/manage/api/internal/search/single_tenant_template", HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
        return new BufferedInputStream(new ByteArrayInputStream((byte[])responseEntity.getBody()));
    }

    public void connectWithoutInteraction(String idpId, String spId, String type, Optional<String> loaLevel) {
        String url = this.manageBaseUrl + "/manage/api/internal/connectWithoutInteraction";
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        bodyMap.put("idpId", idpId);
        bodyMap.put("spId", spId);
        bodyMap.put("spType", type);
        bodyMap.put("user", SpringSecurity.getCurrentUser().getDisplayName());
        bodyMap.put("userUrn", SpringSecurity.getCurrentUser().getUid());
        loaLevel.ifPresent(loa -> bodyMap.put("loaLevel", (String)loa));
        this.restTemplate.exchange(url, HttpMethod.PUT, new HttpEntity(bodyMap, (MultiValueMap)this.httpHeaders), byte[].class, new Object[0]);
    }

    public Map<String, Object> createChangeRequests(ChangeRequest changeRequest) {
        String url = this.manageBaseUrl + "/manage/api/internal/change-requests";
        HttpEntity requestEntity = new HttpEntity((Object)changeRequest, (MultiValueMap)this.httpHeaders);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        return (Map)responseEntity.getBody();
    }

    public List<ChangeRequest> createConnectionRequests(IdentityProvider identityProvider, String spEntityId, EntityType entityType, Optional<String> loaLevel) {
        List changeRequests = this.allowedEntityChangeRequest(identityProvider, spEntityId, entityType, true);
        if (!EntityType.single_tenant_template.equals((Object)entityType)) {
            loaLevel.ifPresent(loa -> this.configureStepupEntity(identityProvider, spEntityId, changeRequests, loa, true));
        }
        return changeRequests;
    }

    public List<ChangeRequest> deactivateConnectionRequests(IdentityProvider identityProvider, String spEntityId, EntityType entityType) {
        List changeRequests = this.allowedEntityChangeRequest(identityProvider, spEntityId, entityType, false);
        this.configureStepupEntity(identityProvider, spEntityId, changeRequests, null, false);
        return changeRequests;
    }

    private void configureStepupEntity(IdentityProvider identityProvider, String spEntityId, List<ChangeRequest> changeRequests, String loa, boolean add) {
        List stepupEntities = identityProvider.getStepupEntities();
        if (!add && stepupEntities.stream().noneMatch(map -> ((String)map.get("name")).equals(spEntityId))) {
            return;
        }
        if (!add && !StringUtils.hasText((String)loa)) {
            loa = "";
        }
        Optional<ChangeRequest> optionalChangeRequest = changeRequests.stream().filter(changeRequest -> changeRequest.getMetaDataId().equals(identityProvider.getInternalId())).findFirst();
        Map<String, Map<String, String>> pathUpdates = Map.of("stepupEntities", Map.of("name", spEntityId, "level", loa));
        if (optionalChangeRequest.isPresent()) {
            ChangeRequest changeRequest2 = optionalChangeRequest.get();
            changeRequest2.getPathUpdates().put("stepupEntities", Map.of("name", spEntityId, "level", loa));
        } else {
            Map auditData = AuditData.context((String)("Added stepup for SP " + spEntityId), null);
            ChangeRequest changeRequest3 = new ChangeRequest(identityProvider.getInternalId(), EntityType.saml20_idp.name(), pathUpdates, auditData, true, add ? PathUpdateType.ADDITION : PathUpdateType.REMOVAL);
            changeRequests.add(changeRequest3);
        }
    }
}

