/*
 * Decompiled with CFR 0.152.
 */
package dashboard.pdp;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import dashboard.pdp.PdpServiceImpl;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestClientException;

public class PdpManage
extends PdpServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(PdpManage.class);
    private final String manageBaseUrl;

    public PdpManage(ObjectMapper objectMapper, String manageBaseUrl, String manageUsername, String managePassword) {
        super(objectMapper, manageBaseUrl, manageUsername, managePassword);
        this.manageBaseUrl = manageBaseUrl;
    }

    protected URI buildUri(String path) {
        Preconditions.checkArgument((boolean)path.startsWith("/"));
        return URI.create(String.format("%s/manage/api/internal%s", this.manageBaseUrl, path));
    }

    public boolean isAvailable() {
        try {
            super.getPdpRestTemplate().getForEntity(this.manageBaseUrl + "/internal/health", Void.class, new Object[0]);
            return true;
        }
        catch (RestClientException e) {
            LOG.warn("Manage is down", (Throwable)e);
            return false;
        }
    }
}

