/*
 * Decompiled with CFR 0.152.
 */
package dashboard.sab;

import com.fasterxml.jackson.databind.ObjectMapper;
import dashboard.sab.Sab;
import dashboard.sab.SabPerson;
import dashboard.sab.SabResponseParser;
import dashboard.sab.SabRole;
import dashboard.sab.SabRoleHolder;
import dashboard.sab.SabTransport;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SabClient
implements Sab {
    private static final Logger LOG = LoggerFactory.getLogger(SabClient.class);
    private static final String REQUEST_TEMPLATE_LOCATION = "/sab-request.xml";
    protected static final DateTimeFormatter XML_DATE_TIME_FORMAT = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SabTransport sabTransport;
    private final SabResponseParser sabResponseParser = new SabResponseParser();

    public SabClient(SabTransport sabTransport) {
        this.sabTransport = sabTransport;
    }

    public Optional<SabRoleHolder> getRoles(String userId) {
        Optional<SabRoleHolder> optional;
        block8: {
            String messageId = UUID.randomUUID().toString();
            String requestBody = this.createRequest(userId, messageId);
            InputStream is = this.sabTransport.getResponse(requestBody);
            try {
                SabRoleHolder sabRoleHolder = this.sabResponseParser.parse(is);
                Optional<Object> optional2 = optional = CollectionUtils.isEmpty((Collection)sabRoleHolder.getRoles()) && !StringUtils.hasText((String)sabRoleHolder.getOrganisation()) ? Optional.empty() : Optional.of(sabRoleHolder);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Skipping SAB entitlement, SAB request got IOException: {}", (Object)e.getMessage());
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    public Collection<SabPerson> getPersonsInRoleForOrganization(String organisationAbbreviation, String role) {
        Collection collection;
        block8: {
            InputStream inputStream = this.sabTransport.getRestResponse(organisationAbbreviation, role);
            try {
                String json = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                LOG.debug("SAB results 'getPersonsInRoleForOrganization' for {} {} is {}", new Object[]{organisationAbbreviation, role, json});
                List profiles = (List)((HashMap)this.objectMapper.readValue(json, HashMap.class)).get("profiles");
                collection = profiles.stream().map(profile -> {
                    List sabRoles = ((List)profile.get("authorisations")).stream().map(authorisation -> new SabRole((String)authorisation.get("short"), (String)authorisation.get("role"))).collect(Collectors.toList());
                    return new SabPerson((String)profile.get("firstname"), (String)profile.get("middlename"), (String)profile.get("surname"), (String)profile.get("uid"), (String)profile.get("email"), sabRoles);
                }).filter(p -> p.hasRole(role)).collect(Collectors.toList());
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("Could not retrieve SAB info", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return collection;
    }

    public List<SabPerson> getSabEmailsForOrganization(String entityId, String role) {
        return new ArrayList<SabPerson>(this.getPersonsInRoleForOrganization(entityId, role));
    }

    public String createRequest(String userId, String messageId) {
        String string;
        block8: {
            InputStream is = this.getClass().getResourceAsStream(REQUEST_TEMPLATE_LOCATION);
            try {
                String template = IOUtils.toString((InputStream)is, (String)"UTF-8");
                String issueInstant = XML_DATE_TIME_FORMAT.print(new Date().getTime());
                string = MessageFormat.format(template, messageId, issueInstant, userId);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }
}

