/*
 * Decompiled with CFR 0.152.
 */
package dashboard.service.impl;

import com.google.common.base.Preconditions;
import dashboard.domain.Action;
import dashboard.domain.Settings;
import dashboard.manage.ChangeRequest;
import dashboard.service.impl.JiraTicketSummaryAndDescriptionBuilder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
class JiraTicketSummaryAndDescriptionBuilder {
    JiraTicketSummaryAndDescriptionBuilder() {
    }

    static SummaryAndDescription build(Action action) {
        Preconditions.checkNotNull((Object)action);
        StringBuilder description = new StringBuilder();
        StringBuilder summary = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)action.getManageUrls())) {
            description.append("A change request in manage has been created to merge this user request.See:\n" + String.join((CharSequence)"\n", action.getManageUrls()) + "\n\n");
        }
        if (action.getType().equals((Object)Action.Type.CHANGE)) {
            Settings settings = action.getSettings();
            if (settings != null && StringUtils.hasText((String)settings.getComments())) {
                description.append("Additional comments: ").append(settings.getComments()).append("\n");
            }
            description.append("\n");
            summary.append("Change settings for ").append(action.getIdpId());
        } else if (Action.Type.LINKREQUEST.equals((Object)action.getType())) {
            description.append("Request: Create a new connection").append("\n");
            summary.append("New connection for IdP ").append(action.getIdpId()).append(" to SP ").append(action.getSpId());
            if (action.getLoaLevel() != null) {
                description.append("\n").append("Note: the user has requested a higher LOA level then default, ").append(action.getLoaLevel()).append("\n");
            }
        } else if (Action.Type.LINKINVITE.equals((Object)action.getType())) {
            description.append("Invite request: If the SCV accepts this invitation then create a new connection by clicking the link to manage in the comments").append("\n");
            summary.append("New invite connection for IdP ").append(action.getIdpId()).append(" to SP ").append(action.getSpId());
        } else if (Action.Type.UNLINKREQUEST.equals((Object)action.getType())) {
            description.append("Request: terminate a connection").append("\n");
            summary.append("Disconnect IdP ").append(action.getIdpId()).append(" and SP ").append(action.getSpId());
        } else {
            throw new IllegalArgumentException("Don't know how to handle tasks of type " + action.getType());
        }
        description.append("Applicant name: ").append(action.getUserName()).append("\n");
        description.append("Applicant email: ").append(action.getUserEmail()).append("\n");
        description.append("Identity Provider: ").append(action.getIdpId()).append("\n");
        description.append("Service Provider: ").append(action.getSpId()).append("\n");
        if (action.getService() != null && action.getService().getLicenseStatus() != null) {
            description.append("License required: ").append(action.getService().getLicenseStatus().getName()).append("\n");
        }
        if (action.getService() != null && action.getService().isAansluitovereenkomstRefused() && Action.Type.LINKREQUEST.equals((Object)action.getType())) {
            description.append("Customer accepts connecting despite aansluitovereenkomst refused").append("\n");
        }
        description.append("Time: ").append(new SimpleDateFormat("HH:mm dd-MM-yy").format(new Date())).append("\n");
        String body = action.getBody();
        description.append("Remark from user: ").append(StringUtils.hasText((String)body) ? body : "None").append("\n");
        List changeRequests = action.getChangeRequests();
        if (!CollectionUtils.isEmpty((Collection)changeRequests)) {
            changeRequests.forEach(changeRequest -> {
                description.append("\n");
                description.append("Functional changes: ").append("\n").append(JiraTicketSummaryAndDescriptionBuilder.convertChangeRequest((ChangeRequest)changeRequest));
            });
        }
        return new SummaryAndDescription(summary.toString(), description.toString());
    }

    private static String convertChangeRequest(ChangeRequest changeRequest) {
        StringBuilder conversion = new StringBuilder();
        changeRequest.getPathUpdates().forEach((key, value) -> {
            conversion.append((String)key);
            conversion.append(" -> ");
            conversion.append(value.toString().replaceAll("[{}]", ""));
            conversion.append("\n");
        });
        return conversion.toString();
    }
}

