/*
 * Decompiled with CFR 0.152.
 */
package dashboard.domain;

import com.google.common.base.MoreObjects;
import dashboard.domain.ContactPerson;
import dashboard.domain.ContactPersonType;
import dashboard.domain.Provider;
import dashboard.manage.EntityType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.springframework.util.CollectionUtils;

public abstract class Provider
implements Comparable<Provider>,
Serializable {
    private String id;
    private String internalId;
    private Long eid;
    private String state;
    private EntityType entityType;
    private String name;
    private String logoUrl;
    private String publishInEdugainDate;
    private Map<String, String> names = new HashMap();
    private Map<String, String> organisations = new HashMap();
    private Map<String, String> homeUrls = new HashMap();
    private Map<String, String> descriptions = new HashMap();
    private Map<String, String> displayNames = new HashMap();
    private boolean linked;
    private List<ContactPerson> contactPersons = new ArrayList();
    private boolean allowedAll;
    private Set<String> allowedEntityIds;
    private boolean noConsentRequired;
    private boolean publishedInEdugain;

    public Provider() {
    }

    public Provider(Map<String, Object> metaData) {
        this.internalId = (String)metaData.get("internalId");
        this.id = (String)metaData.get("entityid");
        this.eid = ((Number)metaData.get("eid")).longValue();
        this.state = (String)metaData.get("state");
        this.addName("en", (String)metaData.get("name:en"));
        this.addName("nl", (String)metaData.get("name:nl"));
        this.addName("pt", (String)metaData.get("name:pt"));
        this.name = this.names.isEmpty() ? (String)metaData.get("entityid") : this.names.getOrDefault("en", (String)this.names.get("nl"));
        this.logoUrl = (String)metaData.get("logo:0:url");
        this.addOrganisation("en", (String)metaData.get("OrganizationDisplayName:en"), (String)metaData.get("OrganizationName:en"));
        this.addOrganisation("nl", (String)metaData.get("OrganizationDisplayName:nl"), (String)metaData.get("OrganizationName:nl"));
        this.addOrganisation("pt", (String)metaData.get("OrganizationDisplayName:pt"), (String)metaData.get("OrganizationName:pt"));
        this.addHomeUrl("en", (String)metaData.get("OrganizationURL:en"));
        this.addHomeUrl("nl", (String)metaData.get("OrganizationURL:nl"));
        this.addHomeUrl("pt", (String)metaData.get("OrganizationURL:pt"));
        this.addDescription("en", (String)metaData.get("description:en"));
        this.addDescription("nl", (String)metaData.get("description:nl"));
        this.addDescription("pt", (String)metaData.get("description:pt"));
        this.addDisplayName("en", (String)metaData.get("displayName:en"));
        this.addDisplayName("nl", (String)metaData.get("displayName:nl"));
        this.addDisplayName("pt", (String)metaData.get("displayName:pt"));
        IntStream.rangeClosed(0, 3).forEach(i -> {
            String contactType = (String)metaData.get("contacts:" + i + ":contactType");
            if (contactType != null) {
                this.addContactPerson(new ContactPerson(this.safeString((Object)(metaData.get("contacts:" + i + ":givenName") + " " + this.safeString(metaData.get("contacts:" + i + ":surName")))).trim(), (String)metaData.get("contacts:" + i + ":emailAddress"), (String)metaData.get("contacts:" + i + ":telephoneNumber"), this.contactPersonType(contactType), this.booleanValue(metaData.get("contacts:" + i + ":isSirtfiSecurityContact")), false));
            }
        });
        this.allowedAll = this.getAllowedAll(metaData);
        this.allowedEntityIds = this.getAllowedEntries(metaData);
        this.noConsentRequired = this.booleanValue(metaData.get("coin:no_consent_required"));
        this.publishedInEdugain = this.booleanValue(metaData.get("coin:publish_in_edugain"));
        this.publishInEdugainDate = (String)metaData.get("coin:publish_in_edugain_date");
    }

    private void addOrganisation(String language, String organisationName, String organisationNameFallback) {
        if (organisationName != null) {
            this.organisations.put(language, organisationName);
        } else if (organisationNameFallback != null) {
            this.organisations.put(language, organisationNameFallback);
        }
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public boolean isLinked() {
        return this.linked;
    }

    public void setLinked(boolean linked) {
        this.linked = linked;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getHomeUrls() {
        return this.homeUrls;
    }

    private void addHomeUrl(String language, String homeUrl) {
        if (homeUrl != null) {
            this.homeUrls.put(language, homeUrl);
        }
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public List<ContactPerson> getContactPersons() {
        return this.contactPersons;
    }

    public ContactPerson getContactPerson(ContactPersonType type) {
        if (CollectionUtils.isEmpty((Collection)this.contactPersons)) {
            return null;
        }
        return this.contactPersons.stream().filter(cp -> cp.getContactPersonType().equals((Object)type)).findFirst().orElse(null);
    }

    public void addContactPerson(ContactPerson contactPerson) {
        this.contactPersons.add(contactPerson);
    }

    public Map<String, String> getNames() {
        return this.names;
    }

    public String getName(Language language) {
        if (this.names == null) {
            return this.getName();
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.names.get(language.name().toLowerCase())))) {
            return this.getName();
        }
        return (String)this.names.get(language.name().toLowerCase());
    }

    public Map<String, String> getOrganisations() {
        return this.organisations;
    }

    public String getOrganisation(Language language) {
        if (this.organisations == null) {
            return this.getName();
        }
        String organisation = (String)this.organisations.get(language.name().toLowerCase());
        if (organisation != null) {
            return organisation;
        }
        return this.organisations.isEmpty() ? "" : (String)this.organisations.values().iterator().next();
    }

    protected void addName(String language, String name) {
        if (name != null) {
            this.names.put(language, name);
        }
    }

    public String getDescription(Language language) {
        if (this.descriptions == null) {
            return null;
        }
        return (String)this.descriptions.get(language.name().toLowerCase());
    }

    public String getDisplayName(Language language) {
        if (this.displayNames == null) {
            return null;
        }
        return (String)this.displayNames.get(language.name().toLowerCase());
    }

    public Map<String, String> getDescriptions() {
        return this.descriptions;
    }

    public Map<String, String> getDisplayNames() {
        return this.displayNames;
    }

    public Long getEid() {
        return this.eid;
    }

    public void setEid(Long eid) {
        this.eid = eid;
    }

    private void addDescription(String language, String description) {
        this.descriptions.put(language, description);
    }

    private void addDisplayName(String language, String displayName) {
        this.displayNames.put(language, displayName);
    }

    public boolean isNoConsentRequired() {
        return this.noConsentRequired;
    }

    public void setNoConsentRequired(boolean noConsentRequired) {
        this.noConsentRequired = noConsentRequired;
    }

    public boolean isAllowedAll() {
        return this.allowedAll;
    }

    public Set<String> getAllowedEntityIds() {
        return this.allowedEntityIds;
    }

    public void addAllowedEntityId(String spId) {
        this.allowedEntityIds.add(spId);
    }

    public String getPublishInEdugainDate() {
        return this.publishInEdugainDate;
    }

    public boolean isPublishedInEdugain() {
        return this.publishedInEdugain;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public String getInternalId() {
        return this.internalId;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    protected boolean booleanValue(Object metadataValue) {
        return metadataValue != null && (metadataValue.equals("1") || metadataValue instanceof Boolean && (Boolean)metadataValue != false);
    }

    protected Boolean booleanOptionalValue(Object metadataValue) {
        return metadataValue == null ? null : Boolean.valueOf(metadataValue.equals("1") || metadataValue instanceof Boolean && (Boolean)metadataValue != false);
    }

    protected String safeString(Object o) {
        return o != null ? o.toString() : "";
    }

    private ContactPersonType contactPersonType(String contactType) {
        try {
            return (ContactPersonType)ContactPersonType.valueOf(ContactPersonType.class, (String)contactType);
        }
        catch (IllegalArgumentException e) {
            return ContactPersonType.other;
        }
    }

    private Set<String> getAllowedEntries(Map<String, Object> entry) {
        List allowedEntities = entry.getOrDefault("allowedEntities", Collections.emptyList());
        return new HashSet<String>(allowedEntities);
    }

    private boolean getAllowedAll(Map<String, Object> entry) {
        String allowedall = (String)entry.getOrDefault("allowedall", "yes");
        return allowedall.equals("yes");
    }

    @Override
    public int compareTo(Provider that) {
        return new CompareToBuilder().append((Object)StringUtils.lowerCase((String)this.name), (Object)StringUtils.lowerCase((String)that.name)).toComparison();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Provider provider = (Provider)o;
        return Objects.equals(this.id, provider.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("names", (Object)this.names).add("id", (Object)this.getId()).add("contactPersons", (Object)this.contactPersons).add("descriptions", (Object)this.descriptions).toString();
    }
}

