/*
 * Decompiled with CFR 0.152.
 */
package dashboard.control;

import com.google.common.base.Strings;
import dashboard.control.BaseController;
import dashboard.control.RestResponse;
import dashboard.control.ServicesController;
import dashboard.domain.Action;
import dashboard.domain.CoinAuthority;
import dashboard.domain.CoinUser;
import dashboard.domain.Consent;
import dashboard.domain.ConsentType;
import dashboard.domain.ContactPerson;
import dashboard.domain.IdentityProvider;
import dashboard.domain.InviteRequest;
import dashboard.domain.JiraFilter;
import dashboard.domain.LoaLevelChange;
import dashboard.domain.MFAChange;
import dashboard.domain.Provider;
import dashboard.domain.ResendInviteRequest;
import dashboard.domain.Service;
import dashboard.domain.ServiceProvider;
import dashboard.domain.Settings;
import dashboard.domain.UpdateInviteRequest;
import dashboard.mail.MailBox;
import dashboard.manage.AuditData;
import dashboard.manage.ChangeRequest;
import dashboard.manage.EntityType;
import dashboard.manage.Manage;
import dashboard.manage.PathUpdateType;
import dashboard.service.ActionsService;
import dashboard.service.Services;
import dashboard.util.SpringSecurity;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard/api/users"}, produces={"application/json"})
public class UsersController
extends BaseController {
    @Autowired
    private Manage manage;
    @Autowired
    private Services services;
    @Autowired
    private ActionsService actionsService;
    @Autowired
    private MailBox mailbox;
    @Value(value="${manage.manageBaseUrl}")
    private String manageBaseUrl;
    @Value(value="${dashboard.feature.stepup}")
    private boolean dashboardStepupEnabled;
    private static final Logger LOG = LoggerFactory.getLogger(UsersController.class);

    @RequestMapping(value={"/me"})
    public RestResponse<CoinUser> me() {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        currentUser.setDashboardStepupEnabled(this.dashboardStepupEnabled);
        return this.createRestResponse((Object)currentUser);
    }

    @PreAuthorize(value="hasRole('DASHBOARD_SUPER_USER')")
    @PostMapping(value={"/inviteRequest"})
    public ResponseEntity<RestResponse<Object>> inviteRequest(@RequestBody InviteRequest inviteRequest) {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        String spEntityId = inviteRequest.getSpEntityId();
        String emails = inviteRequest.getContactPersons().stream().map(cp -> cp.getName() + "<" + cp.getEmailAddress() + ">").collect(Collectors.joining(", "));
        String emailTo = inviteRequest.getContactPersons().stream().map(ContactPerson::getEmailAddress).collect(Collectors.joining(", "));
        String body = "Invite request initiated by dashboard super user. Mails sent to: " + emails + ".";
        if (inviteRequest.isContainsMessage()) {
            body = body + " The invitation message from the SURFconext super user:\n" + inviteRequest.getMessage();
        }
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).body(body).personalMessage(inviteRequest.getMessage()).emailTo(emailTo).typeMetaData(inviteRequest.getTypeMetaData()).idpId(inviteRequest.getIdpEntityId()).spId(spEntityId).type(Action.Type.LINKINVITE).build();
        action = this.actionsService.create(action);
        this.mailbox.sendInviteMail(inviteRequest, action);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_SUPER_USER')")
    @PutMapping(value={"/inviteRequest"})
    public ResponseEntity<RestResponse<Object>> updateInviteRequest(@RequestBody UpdateInviteRequest updateInviteRequest, Locale locale) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        String commentWithUser = String.format("%s / %s has %s this Invite request.", currentUser.getUid(), currentUser.getFriendlyName(), updateInviteRequest.getStatus().name().toLowerCase());
        String comment = updateInviteRequest.getComment();
        if (StringUtils.hasText((String)comment)) {
            commentWithUser = commentWithUser.concat(" User comment: ").concat(comment);
        }
        String jiraKey = updateInviteRequest.getJiraKey();
        if (UpdateInviteRequest.Status.ACCEPTED.equals((Object)updateInviteRequest.getStatus())) {
            try {
                boolean connected = this.automaticallyCreateConnection(locale, updateInviteRequest);
                if (connected) {
                    updateInviteRequest.setConnectWithoutInteraction(true);
                    commentWithUser = commentWithUser.concat("\nThe connection in Manage is already made as the SP is configured to automatically connect without interaction");
                } else {
                    IdentityProvider identityProvider = currentUser.getCurrentIdp();
                    EntityType entityType = EntityType.valueOf((String)updateInviteRequest.getTypeMetaData());
                    List changeRequests = this.manage.createConnectionRequests(identityProvider, updateInviteRequest.getSpEntityId(), entityType, updateInviteRequest.getOptionalLoaLevel());
                    if (!changeRequests.isEmpty()) {
                        commentWithUser = commentWithUser.concat("\nTo create the connection in Manage a change request is made:\n");
                    }
                    for (ChangeRequest changeRequest : changeRequests) {
                        String identifier = changeRequest.getMetaDataId();
                        String entityTypeValue = identifier.equals(identityProvider.getInternalId()) ? EntityType.saml20_idp.name() : entityType.name();
                        commentWithUser = commentWithUser.concat(String.format("%s/metadata/%s/%s/requests\n", this.manageBaseUrl, entityTypeValue, identifier));
                        changeRequest.setAuditData(AuditData.context((String)("Invite request accepted and connected SP " + updateInviteRequest.getSpEntityId()), (String)jiraKey));
                        this.manage.createChangeRequests(changeRequest);
                    }
                }
                this.actionsService.approveInviteRequest(jiraKey, commentWithUser, connected);
            }
            catch (Exception e) {
                LOG.error("Something went wrong in remote API", (Throwable)e);
                this.actionsService.comment(jiraKey, "The connection could not be made automatically due to an error in remote API: " + e.getMessage() + ". Please contact the dashboard TPM to check the logs.");
                throw e;
            }
        } else {
            this.actionsService.rejectInviteRequest(jiraKey, commentWithUser);
        }
        return ResponseEntity.ok((Object)this.createRestResponse((Object)updateInviteRequest));
    }

    private boolean automaticallyCreateConnection(Locale locale, UpdateInviteRequest updateInviteRequest) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        IdentityProvider idp = currentUser.getSwitchedToIdp().orElse(currentUser.getIdp());
        Optional serviceOptional = this.automaticallyCreateConnectionAllowed(currentUser, locale, updateInviteRequest);
        if (serviceOptional.isPresent()) {
            Service service = (Service)serviceOptional.get();
            Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).body(updateInviteRequest.getComment()).idpId(idp.getId()).spId(updateInviteRequest.getSpEntityId()).typeMetaData(updateInviteRequest.getTypeMetaData()).connectWithoutInteraction(true).shouldSendEmail(service.sendsEmailWithoutInteraction()).service(service).type(Action.Type.LINKREQUEST).build();
            this.actionsService.connectWithoutInteraction(action, updateInviteRequest.getOptionalLoaLevel());
            return true;
        }
        return false;
    }

    private Optional<Service> automaticallyCreateConnectionAllowed(CoinUser currentUser, Locale locale, UpdateInviteRequest updateInviteRequest) throws IOException {
        IdentityProvider idp = currentUser.getSwitchedToIdp().orElse(currentUser.getIdp());
        String idpEntityId = idp.getId();
        if (Strings.isNullOrEmpty((String)idp.getInstitutionId())) {
            return Optional.empty();
        }
        String spEntityId = updateInviteRequest.getSpEntityId();
        List services = this.services.getServicesForIdp(idpEntityId, true, locale);
        Optional<Service> optional = services.stream().filter(s -> s.getSpEntityId().equals(spEntityId)).findFirst();
        if (optional.isPresent()) {
            boolean idpAndSpShareInstitution;
            Service service = optional.get();
            String institutionId = service.getInstitutionId();
            boolean bl = idpAndSpShareInstitution = institutionId != null && institutionId.equals(idp.getInstitutionId());
            if (idpAndSpShareInstitution || service.connectsWithoutInteraction()) {
                return optional;
            }
        }
        return Optional.empty();
    }

    @PreAuthorize(value="hasRole('DASHBOARD_SUPER_USER')")
    @PostMapping(value={"/resendInviteRequest"})
    public ResponseEntity<RestResponse<Object>> resendInviteRequest(@RequestBody ResendInviteRequest resendInviteRequest) throws IOException, MessagingException {
        JiraFilter jiraFilter = new JiraFilter();
        jiraFilter.setKey(resendInviteRequest.getJiraKey());
        Action action = (Action)this.actionsService.searchTasks(resendInviteRequest.getIdpId(), jiraFilter).getIssues().stream().findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Jira issue with key %s for IdP %s not found.", resendInviteRequest.getJiraKey(), resendInviteRequest.getIdpId())));
        String emailTo = action.getEmailTo();
        if (!StringUtils.hasText((String)emailTo)) {
            throw new IllegalArgumentException(String.format("There are no emails set on issue %s", resendInviteRequest.getJiraKey()));
        }
        this.mailbox.sendInviteMailReminder(action, resendInviteRequest.getComments());
        this.actionsService.updateOptionalMessage(resendInviteRequest.getJiraKey(), resendInviteRequest.getComments());
        return ResponseEntity.ok((Object)this.createRestResponse((Object)resendInviteRequest));
    }

    @RequestMapping(value={"/disableConsent"})
    public List<Consent> disableConsent() {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isGuest()) {
            return Collections.emptyList();
        }
        IdentityProvider idp = currentUser.getSwitchedToIdp().orElse(currentUser.getIdp());
        String id = idp.getId();
        return ((IdentityProvider)this.manage.getIdentityProvider(id, false).orElseThrow(() -> new IllegalArgumentException(String.format("IdP %s not found", id)))).getDisableConsent();
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/super/idps"})
    public ResponseEntity<RestResponse<Map<String, List<?>>>> idps() {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (!currentUser.isSuperUser()) {
            LOG.warn("IdP's endpoint is only allowed for superUser, not for {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        List idps = this.manage.getAllIdentityProviders().stream().sorted(Comparator.comparing(Provider::getName)).collect(Collectors.toList());
        List<String> roles = Arrays.asList(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER.name(), CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN.name());
        HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
        payload.put("idps", idps);
        payload.put("roles", roles);
        return new ResponseEntity((Object)this.createRestResponse(payload), HttpStatus.OK);
    }

    @RequestMapping(value={"/me/serviceproviders"}, method={RequestMethod.GET})
    public RestResponse<List<Service>> serviceProviders(Locale locale) throws IOException {
        boolean eraseMails;
        List usersServices = this.getServiceProvidersForCurrentUser(locale);
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        IdentityProvider idp = currentUser.getSwitchedToIdp().orElse(currentUser.getIdp());
        boolean bl = eraseMails = currentUser.isGuest() || currentUser.isDashboardMember() && !idp.isDisplayAdminEmailsInDashboard();
        if (eraseMails) {
            usersServices = usersServices.stream().map(service -> ServicesController.eraseMailsFromService((Service)service)).collect(Collectors.toList());
        }
        return this.createRestResponse((Object)usersServices);
    }

    private List<Service> getServiceProvidersForCurrentUser(Locale locale) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        Optional switchedToIdp = currentUser.getSwitchedToIdp();
        String usersInstitutionId = switchedToIdp.isPresent() ? ((IdentityProvider)switchedToIdp.get()).getInstitutionId() : currentUser.getInstitutionId();
        return Strings.isNullOrEmpty((String)usersInstitutionId) ? Collections.emptyList() : this.services.getInstitutionalServicesForIdp(usersInstitutionId, locale);
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/me/switch-to-idp"})
    public ResponseEntity<Void> currentIdp(@RequestParam(value="idpId", required=false) String switchToIdp, @RequestParam(value="role", required=false) String role) {
        if (Strings.isNullOrEmpty((String)switchToIdp)) {
            SpringSecurity.clearSwitchedIdp();
        } else {
            IdentityProvider identityProvider = (IdentityProvider)this.manage.getIdentityProvider(switchToIdp, false).orElseThrow(() -> new SecurityException(switchToIdp + " does not exist"));
            SpringSecurity.setSwitchedToIdp((IdentityProvider)identityProvider, (String)role);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/me/consent"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Object>> updateConsentSettings(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestBody Consent consent) {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin() && currentUser.isDashboardViewer()) {
            LOG.warn("Consent endpoint is not allowed for superUser / dashboardViewer, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        if (currentUser.getCurrentLoaLevel() < 2 && this.dashboardStepupEnabled) {
            LOG.warn("Consent endpoint requires LOA level 2 or higher, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        IdentityProvider idp = currentUser.getSwitchedToIdp().orElse(currentUser.getIdp());
        List currentDisableConsent = idp.getDisableConsent();
        Optional<Consent> previousConsent = currentDisableConsent.stream().filter(c -> c.getSpEntityId().equals(consent.getSpEntityId())).findAny();
        if (!previousConsent.isPresent() && consent.getType().equals((Object)ConsentType.MINIMAL_CONSENT) && !StringUtils.hasText((String)consent.getExplanationEn()) && !StringUtils.hasText((String)consent.getExplanationNl()) || previousConsent.map(c -> c.getType().equals((Object)consent.getType()) && Objects.equals(c.getExplanationEn(), consent.getExplanationEn()) && Objects.equals(c.getExplanationNl(), consent.getExplanationNl())).orElse(Boolean.FALSE).booleanValue()) {
            return ResponseEntity.ok((Object)this.createRestResponse(Collections.singletonMap("no-changes", true)));
        }
        Map<String, Map<String, String>> pathUpdates = Map.of("disableConsent", Map.of("name", consent.getSpEntityId(), "type", consent.getType().name().toLowerCase(), "explanation:en", consent.getExplanationEn(), "explanation:nl", consent.getExplanationNl()));
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).idpId(idpEntityId).spId(consent.getSpEntityId()).typeMetaData(consent.getTypeMetaData()).consent(consent).manageUrls(Collections.singletonList(String.format("%s/metadata/%s/%s/requests", this.manageBaseUrl, EntityType.saml20_idp.name(), idp.getInternalId()))).type(Action.Type.CHANGE).build();
        ChangeRequest changeRequest = new ChangeRequest(idp.getInternalId(), EntityType.saml20_idp.name(), pathUpdates, null, true, PathUpdateType.ADDITION);
        action.addChangeRequests(Collections.singletonList(changeRequest));
        action = this.actionsService.create(action);
        Map auditData = AuditData.context((String)("Update consent settings for SP " + consent.getSpEntityId()), (String)action.getJiraKey());
        changeRequest.setAuditData(auditData);
        this.manage.createChangeRequests(changeRequest);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/me/surfsecureid"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Object>> updateSurfSecureId(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestBody LoaLevelChange loaLevelChange) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin()) {
            LOG.warn("SURF secure ID endpoint is not allowed for superUser / dashboardViewer, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        if (currentUser.getCurrentLoaLevel() < 3 && this.dashboardStepupEnabled) {
            LOG.warn("SURFsecureID endpoint is not allowed without LOA level 3, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        ServiceProvider serviceProvider = (ServiceProvider)this.manage.getServiceProvider(loaLevelChange.getEntityId(), EntityType.valueOf((String)loaLevelChange.getEntityType()), false).orElseThrow(IllegalArgumentException::new);
        String minimalLoaLevel = serviceProvider.getMinimalLoaLevel();
        if (StringUtils.hasText((String)minimalLoaLevel)) {
            LOG.warn("SURF secure ID endpoint is not allowed for SP that already has a loa-level {}", (Object)serviceProvider);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        IdentityProvider idp = currentUser.getSwitchedToIdp().orElse(currentUser.getIdp());
        List currentStepupEntities = idp.getStepupEntities().stream().map(HashMap::new).collect(Collectors.toList());
        Optional<Map> previousLoa = currentStepupEntities.stream().filter(entity -> ((String)entity.get("name")).equals(loaLevelChange.getEntityId())).findFirst();
        if (!previousLoa.isPresent() && !StringUtils.hasText((String)loaLevelChange.getLoaLevel()) || previousLoa.map(loa -> ((String)loa.get("level")).equals(loaLevelChange.getLoaLevel())).orElse(Boolean.FALSE).booleanValue()) {
            return ResponseEntity.ok((Object)this.createRestResponse(Collections.singletonMap("no-changes", true)));
        }
        Map<String, Map<String, String>> pathUpdates = Map.of("stepupEntities", Map.of("name", loaLevelChange.getEntityId(), "level", loaLevelChange.getLoaLevel()));
        boolean removal = previousLoa.isPresent() && !StringUtils.hasText((String)loaLevelChange.getLoaLevel());
        PathUpdateType pathUpdateType = removal ? PathUpdateType.REMOVAL : PathUpdateType.ADDITION;
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).idpId(idpEntityId).spId(loaLevelChange.getEntityId()).loaLevel(loaLevelChange.getLoaLevel()).manageUrls(Collections.singletonList(String.format("%s/metadata/%s/%s/requests", this.manageBaseUrl, EntityType.saml20_idp.name(), idp.getInternalId()))).type(Action.Type.CHANGE).build();
        ChangeRequest changeRequest = new ChangeRequest(idp.getInternalId(), EntityType.saml20_idp.name(), pathUpdates, null, true, pathUpdateType);
        action.addChangeRequests(Collections.singletonList(changeRequest));
        action = this.actionsService.create(action);
        String ctx = removal ? "Removed" : "Added";
        Map auditData = AuditData.context((String)(ctx + " SURFsecureID settings for SP " + loaLevelChange.getEntityId()), (String)action.getJiraKey());
        changeRequest.setAuditData(auditData);
        this.manage.createChangeRequests(changeRequest);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/me/mfa"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Object>> updateMFA(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestBody MFAChange mfaChange) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin()) {
            LOG.warn("SURF secure ID endpoint is not allowed for superUser / dashboardViewer, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        if (currentUser.getCurrentLoaLevel() < 3 && this.dashboardStepupEnabled) {
            LOG.warn("MFA endpoint is not allowed without LOA level 3, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        IdentityProvider idp = currentUser.getSwitchedToIdp().orElse(currentUser.getIdp());
        List mfaEntities = idp.getMfaEntities().stream().map(HashMap::new).collect(Collectors.toList());
        Optional<Map> previousMfa = mfaEntities.stream().filter(entity -> ((String)entity.get("name")).equals(mfaChange.getEntityId())).findFirst();
        if (!previousMfa.isPresent() && !StringUtils.hasText((String)mfaChange.getAuthnContextLevel()) || previousMfa.map(mfa -> ((String)mfa.get("level")).equals(mfaChange.getAuthnContextLevel())).orElse(Boolean.FALSE).booleanValue()) {
            return ResponseEntity.ok((Object)this.createRestResponse(Collections.singletonMap("no-changes", true)));
        }
        Map<String, Map<String, String>> pathUpdates = Map.of("mfaEntities", Map.of("name", mfaChange.getEntityId(), "level", mfaChange.getAuthnContextLevel()));
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).idpId(idpEntityId).spId(mfaChange.getEntityId()).mfaLevel(mfaChange.getAuthnContextLevel()).manageUrls(Collections.singletonList(String.format("%s/metadata/%s/%s/requests", this.manageBaseUrl, EntityType.saml20_idp.name(), idp.getInternalId()))).type(Action.Type.CHANGE).build();
        ChangeRequest changeRequest = new ChangeRequest(idp.getInternalId(), EntityType.saml20_idp.name(), pathUpdates, null, true, PathUpdateType.ADDITION);
        action.addChangeRequests(Collections.singletonList(changeRequest));
        action = this.actionsService.create(action);
        String ctx = previousMfa.isPresent() ? "Changed" : "Added";
        Map auditData = AuditData.context((String)(ctx + " MFA settings for SP " + mfaChange.getEntityId()), (String)action.getJiraKey());
        changeRequest.setAuditData(auditData);
        this.manage.createChangeRequests(changeRequest);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    @PreAuthorize(value="hasAnyRole('DASHBOARD_ADMIN','DASHBOARD_VIEWER','DASHBOARD_SUPER_USER')")
    @RequestMapping(value={"/me/settings"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Object>> updateSettings(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, @RequestBody Settings settings) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin() && currentUser.isDashboardViewer()) {
            LOG.warn("Settings endpoint is not allowed for superUser / dashboardViewer, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        if (currentUser.getCurrentLoaLevel() < 2 && this.dashboardStepupEnabled) {
            LOG.warn("Settings endpoint is not allowed without LOA level 2, currentUser {}", (Object)currentUser);
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        IdentityProvider idp = currentUser.getSwitchedToIdp().orElse(currentUser.getIdp());
        Map pathUpdates = this.getPathUpdates(settings, idp);
        if (pathUpdates.isEmpty()) {
            return ResponseEntity.ok((Object)this.createRestResponse(Collections.singletonMap("no-changes", true)));
        }
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getFriendlyName()).idpId(idpEntityId).spId("N/A").settings(settings).typeMetaData(settings.getTypeMetaData()).manageUrls(Collections.singletonList(String.format("%s/metadata/%s/%s/requests", this.manageBaseUrl, EntityType.saml20_idp.name(), idp.getInternalId()))).type(Action.Type.CHANGE).build();
        ChangeRequest changeRequest = new ChangeRequest(idp.getInternalId(), EntityType.saml20_idp.name(), pathUpdates, null, false, null);
        action.addChangeRequests(Collections.singletonList(changeRequest));
        action = this.actionsService.create(action);
        Map auditData = AuditData.context((String)("Update metadata for IdP " + idpEntityId), (String)action.getJiraKey());
        changeRequest.setAuditData(auditData);
        this.manage.createChangeRequests(changeRequest);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    protected Map<String, Object> getPathUpdates(Settings settings, IdentityProvider idp) throws IOException {
        HashMap<String, Object> pathUpdates = new HashMap<String, Object>();
        this.diff(pathUpdates, idp.getKeywords().get("en"), (Object)settings.getKeywordsEn(), "keywords:en");
        this.diff(pathUpdates, idp.getKeywords().get("nl"), (Object)settings.getKeywordsNl(), "keywords:nl");
        this.diff(pathUpdates, idp.getKeywords().get("pt"), (Object)settings.getKeywordsPt(), "keywords:pt");
        this.diff(pathUpdates, idp.getHomeUrls().get("en"), (Object)settings.getOrganisationUrlEn(), "OrganizationURL:en");
        this.diff(pathUpdates, idp.getHomeUrls().get("nl"), (Object)settings.getOrganisationUrlNl(), "OrganizationURL:nl");
        this.diff(pathUpdates, idp.getHomeUrls().get("pt"), (Object)settings.getOrganisationUrlPt(), "OrganizationURL:pt");
        this.diff(pathUpdates, idp.getOrganisationDisplayNames().get("en"), (Object)settings.getOrganisationDisplayNameEn(), "OrganizationDisplayName:en");
        this.diff(pathUpdates, idp.getOrganisationDisplayNames().get("nl"), (Object)settings.getOrganisationDisplayNameNl(), "OrganizationDisplayName:nl");
        this.diff(pathUpdates, idp.getOrganisationDisplayNames().get("pt"), (Object)settings.getOrganisationDisplayNamePt(), "OrganizationDisplayName:pt");
        this.diff(pathUpdates, idp.getOrganisationNames().get("en"), (Object)settings.getOrganisationNameEn(), "OrganizationName:en");
        this.diff(pathUpdates, idp.getOrganisationNames().get("nl"), (Object)settings.getOrganisationNameNl(), "OrganizationName:nl");
        this.diff(pathUpdates, idp.getOrganisationNames().get("pt"), (Object)settings.getOrganisationNamePt(), "OrganizationName:pt");
        this.diff(pathUpdates, idp.getDescriptions().get("en"), (Object)settings.getDescriptionsEn(), "description:en");
        this.diff(pathUpdates, idp.getDescriptions().get("nl"), (Object)settings.getDescriptionsNl(), "description:nl");
        this.diff(pathUpdates, idp.getDescriptions().get("pt"), (Object)settings.getDescriptionsPt(), "description:pt");
        this.diff(pathUpdates, idp.getDisplayNames().get("en"), (Object)settings.getDisplayNamesEn(), "displayName:en");
        this.diff(pathUpdates, idp.getDisplayNames().get("nl"), (Object)settings.getDisplayNamesNl(), "displayName:nl");
        this.diff(pathUpdates, idp.getDisplayNames().get("pt"), (Object)settings.getDisplayNamesPt(), "displayName:pt");
        this.diff(pathUpdates, (Object)idp.isPublishedInEdugain(), (Object)settings.isPublishedInEdugain(), "coin:publish_in_edugain");
        if (this.changed((Object)idp.isConnectToRSServicesAutomatically(), (Object)settings.isConnectToRSServicesAutomatically())) {
            pathUpdates.put("metaDataFields.coin:entity_categories:1", "http://refeds.org/category/research-and-scholarship");
        }
        this.diff(pathUpdates, (Object)idp.isAllowMaintainersToManageAuthzRules(), (Object)settings.isAllowMaintainersToManageAuthzRules(), "coin:allow_maintainers_to_manage_authz_rules");
        this.diff(pathUpdates, (Object)idp.isDisplayAdminEmailsInDashboard(), (Object)settings.isDisplayAdminEmailsInDashboard(), "coin:display_admin_emails_in_dashboard");
        this.diff(pathUpdates, (Object)idp.isDisplayStatsInDashboard(), (Object)settings.isDisplayStatsInDashboard(), "coin:display_stats_in_dashboard");
        this.diff(pathUpdates, (Object)idp.getState(), (Object)(settings.getStateType() != null ? settings.getStateType().name() : null), "state");
        this.diffContactPersons(pathUpdates, idp.getContactPersons(), settings.getContactPersons());
        return pathUpdates;
    }

    private String givenName(List<String> names) {
        return names.get(0);
    }

    private String surName(List<String> names) {
        return names.size() > 1 ? String.join((CharSequence)" ", names.subList(1, names.size())) : "";
    }

    private void diffContactPersons(Map<String, Object> pathUpdates, List<ContactPerson> contactPersons, List<ContactPerson> newContactPersons) {
        if (CollectionUtils.isEmpty(contactPersons) && CollectionUtils.isEmpty(newContactPersons)) {
            return;
        }
        for (int i = 0; i < contactPersons.size(); ++i) {
            ContactPerson contactPerson = contactPersons.get(i);
            if (newContactPersons == null || newContactPersons.size() < i + 1) continue;
            ContactPerson newContactPerson = newContactPersons.get(i);
            List<String> names = Arrays.asList(contactPerson.getName().split(" "));
            String givenName = this.givenName(names);
            String surName = this.surName(names);
            List<String> newNames = Arrays.asList(newContactPerson.getName().split(" "));
            String newGivenName = this.givenName(newNames);
            String newSurName = this.surName(newNames);
            this.diff(pathUpdates, (Object)givenName, (Object)newGivenName, "contacts:" + i + ":givenName");
            this.diff(pathUpdates, (Object)surName, (Object)newSurName, "contacts:" + i + ":surName");
            this.diff(pathUpdates, (Object)contactPerson.getEmailAddress(), (Object)newContactPerson.getEmailAddress(), "contacts:" + i + ":emailAddress");
            this.diff(pathUpdates, (Object)contactPerson.getTelephoneNumber(), (Object)newContactPerson.getTelephoneNumber(), "contacts:" + i + ":telephoneNumber");
            this.diff(pathUpdates, (Object)contactPerson.getContactPersonType(), (Object)newContactPerson.getContactPersonType(), "contacts:" + i + ":contactType");
        }
    }

    private void diff(Map<String, Object> pathUpdates, Object oldValue, Object newValue, String attributeName) {
        if (this.changed(oldValue, newValue)) {
            if (newValue instanceof String) {
                newValue = StringUtils.hasText((String)((String)newValue)) ? newValue : null;
            }
            pathUpdates.put(String.format("metaDataFields.%s", attributeName), newValue);
        }
    }

    private boolean changed(Object oldValue, Object newValue) {
        boolean newNotNull;
        boolean oldNotNull;
        boolean bl = oldValue instanceof String ? StringUtils.hasText((String)((String)oldValue)) : (oldNotNull = oldValue != null);
        boolean bl2 = newValue instanceof String ? StringUtils.hasText((String)((String)newValue)) : (newNotNull = newValue != null);
        if (!oldNotNull && !newNotNull) {
            return false;
        }
        if (oldNotNull && !newNotNull) {
            return true;
        }
        if (!oldNotNull && newNotNull) {
            return true;
        }
        return !oldValue.equals(newValue);
    }
}

