/*
 * Decompiled with CFR 0.152.
 */
package dashboard;

import dashboard.control.GsonHttpMessageConverter;
import dashboard.util.CookieThenAcceptHeaderLocaleResolver;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@Configuration
public class WebConfig
implements WebMvcConfigurer {
    private static final String LANG = "language";
    @Value(value="${dashboard.feature.statistics}")
    private boolean statsEnabled;

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.mediaType("csv", new MediaType("text", "csv"));
    }

    @Bean
    public LocaleResolver localeResolver(@Value(value="${supported_language_codes}") String supportLanguageCodes) {
        String language = Stream.of(supportLanguageCodes.split(",")).map(String::trim).findFirst().orElse("nl");
        CookieThenAcceptHeaderLocaleResolver localeResolver = new CookieThenAcceptHeaderLocaleResolver();
        localeResolver.setCookieName(LANG);
        localeResolver.setDefaultLocale(Locale.of(language));
        localeResolver.setCookieMaxAge(Integer.valueOf(315360000));
        return localeResolver;
    }

    @Bean
    public HttpFirewall httpFirewall() {
        StrictHttpFirewall firewall = new StrictHttpFirewall();
        firewall.setAllowedHeaderValues(s -> true);
        return firewall;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName(LANG);
        registry.addInterceptor((HandlerInterceptor)localeChangeInterceptor);
        registry.addInterceptor((HandlerInterceptor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(0, (HttpMessageConverter<?>)new GsonHttpMessageConverter(this.statsEnabled));
    }
}

